FormManager.afterCreateAllForms.subscribe(function () {
	let form = FormManager.byname('TnFpaDMPeriodoCalculo', '');

	$('#ctrlCODIGOTIPOCALC').change(LimpaCompetencia);
	$('#ctrlCODIGOPERCALCCOMPL').change(LimpaCompetencia);
	$('#ctrlTIPODCTOCOMPL').change(ExibeOcultaOutrasInformacoes);

	form.AfterLoadDataSubject.subscribe(function () {
		let codigoEmpresa = form.getvalue('CODIGOEMPRESA');
		let codigoTipoCalc = form.getvalue('CODIGOTIPOCALC');
		let compet = form.getvalue('COMPET');

		if ((codigoEmpresa) && (codigoTipoCalc) && (compet)) {
			let params = `${codigoEmpresa};${codigoTipoCalc};${compet}`;
			configurarLabelStatusPeriodo(params);
			configurarLabelStatusDCTFWeb(params);
		}
	});

	function configurarLabelStatusPeriodo(params) {
		AJaxCadastroExecuteMethodGetProperty('TnFpaDMPeriodoCalculo', 'ConfigurarLabelStatusCloud', params, 'Recibo', (retorno) => {
			if (retorno.data.result) {
				document.getElementById('widget_valor_Widget3').innerHTML = "Periodo Fechado" + retorno.data.Recibo;
				document.getElementById('widget_valor_Widget3').style.color = "rgb(255, 0, 0)";
			} else {
				document.getElementById('widget_valor_Widget3').innerHTML = "Periodo Aberto";
				document.getElementById('widget_valor_Widget3').style.color = "rgb(0, 225, 0)";
			}
		});
	}

	function configurarLabelStatusDCTFWeb(params) {
		AJaxCadastroExecuteMethodGetProperty('TnFpaDMPeriodoCalculo', 'ConfigurarLabelStatusDCTFWebCloud', params, 'ProcessouDCTFWeb', (retorno) => {
			if (retorno.data.result) {
				document.getElementById('widget_valor_Widget4').innerHTML = retorno.data.ProcessouDCTFWeb;
				document.getElementById('widget_valor_Widget4').style.color = "rgb(255, 0, 0)";
			} else {
				document.getElementById('widget_valor_Widget4').innerHTML = "";
			}
		});
	}

	function LimpaCompetencia() {
		form.setvalue('COMPET', ' ');
		ExibeOcultaOutrasInformacoes();
	}

	function ExibeOcultaOutrasInformacoes() {
		let codigoTipoCalc = form.getvalue('CODIGOTIPOCALC');
		let tipoDctoCompl = form.getvalue('TIPODCTOCOMPL');
		document.getElementById('widget_Widget0').style.display = 'none';
		if ((codigoTipoCalc == 7 || codigoTipoCalc == 9) && (tipoDctoCompl == 3)) {
			document.getElementById('widget_Widget0').style.display = 'initial';
		}
	}
});
