FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMProgFerias', '');
	let formDiasDescon = FormManager.byname('TnFpaDMProgFeriasDiasDescon', '');

	function execDatasFinalFerias(){
		let dataFinalFeriasOld = formAtual.getvalue('FIMPROGFERIAS');

		BuscarFimProgFerias().then(() => {
			if (dataFinalFeriasOld != formAtual.getvalue('FIMPROGFERIAS')) {
				setDataRetornoFerias(formAtual.getvalue('FIMPROGFERIAS'));
			}
		})
	}

	formDiasDescon.AfterModal = formDiasDescon.AfterDelete = () => {
		let dataFinalFeriasOld = formAtual.getvalue('FIMPROGFERIAS');

		setDataAbono();
		BuscarFimProgFerias().then(() => {
			if (dataFinalFeriasOld != formAtual.getvalue('FIMPROGFERIAS')) {
				setDataRetornoFerias(formAtual.getvalue('FIMPROGFERIAS')).then(() => {
					setTimeout(() => {
						formAtual.executeAction('actDataSetPostExecute');
					}, 300);
				});
			}
		});
	}

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMProgFeriasDiasDescon').refresh();
	})

	formAtual.AfterLoadDataSubject.subscribe(function () {
		if (formAtual.estado === FormState.cadInsert || formAtual.estado === FormState.cadAlterando) {
			if (formAtual.getcomponent('DIASABONO') != null) {
				formAtual.getcomponent('DIASABONO').blur(execDatasFinalFerias);
			}

			if (formAtual.getcomponent('INICPROGFERIAS') != null){
				formAtual.getcomponent('INICPROGFERIAS').blur(execDatasFinalFerias);
			}

			if (formAtual.getcomponent('DIASFERIAS') != null){
				formAtual.getcomponent('DIASFERIAS').blur(execDatasFinalFerias);
			}
		}
	})

	formAtual.AfterLoadDataSubject.subscribe(function () {
		if (formAtual.estado === FormState.cadInsert || formAtual.estado === FormState.cadAlterando) {
			if (formAtual.getcomponent('DIASABONO') != null) {
				formAtual.getcomponent('DIASABONO').blur(BuscarFimProgFerias);
			}
		}
	})

	async function setDataAbono() {
		let Executor = new nExpressionExecutor();
		const values = formAtual.getValues();
		let params = `${values.CODIGOEMPRESA},${values.CODIGOFUNCCONTR},'${values.DATAINICIAL}','${values.INICPROGFERIAS}','${values.DIASFERIAS}','true'`;
		return Executor.execute(`EXTERNO("PEGARDATAFINALABONO", [${params}])`)
			.then((result) => {
				formAtual.setvalue('DATAABONO', result);
				KTApp.unblockPage();
			})
			.catch(() => {
				KTApp.unblockPage();
			});
	}

	async function setDataRetornoFerias(DATAFINALFERIAS){
		let Executor = new nExpressionExecutor();
		const values = formAtual.getValues();
		let params = `${values.CODIGOEMPRESA},${values.CODIGOFUNCCONTR},'${values.INICPROGFERIAS}','${DATAFINALFERIAS}','${values.DATAABONO||0}','${values.DIASABONO}'`;
		Executor.execute(`EXTERNO("DATARETORNOFERIAS", [${params}])`).then((result) => {
			formAtual.setvalue('DATARETORNOFERIAS', result);
		});
		KTApp.unblockPage();
	}

	BuscarFimProgFerias = () => {
		return new Promise((resolve) => {
			let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
			let seqReciboFerias = formAtual.getvalue('SEQRECIBOFERIAS');
			let dataInicial = moment(formAtual.getvalue('DATAINICIAL'), 'YYYY-MM-DD').format('DD/MM/YYYY');;
			let inicProgFerias = moment(formAtual.getvalue('INICPROGFERIAS'), 'YYYY-MM-DD').format('DD/MM/YYYY');;
			let diasFerias = formAtual.getvalue('DIASFERIAS');
			let diasAbono = formAtual.getvalue('DIASABONO');

			if ((codigoEmpresa) && (codigoFuncContr) && (seqReciboFerias) && (dataInicial) && (inicProgFerias) && (diasFerias) && (diasAbono)) {
				$achave = `${codigoEmpresa};${codigoFuncContr};${seqReciboFerias};${dataInicial};${inicProgFerias};${diasFerias};${diasAbono}`;

				AJaxCadastroExecuteMethodGetProperty('TnFpaDMProgFerias', 'BuscarFimProgFeriasCloudAjax', $achave, '', (retorno) => {
					if (retorno.data.result) {
						formAtual.setvalue('FIMPROGFERIAS', retorno.data.result);
					}
					resolve();
				});
			}
		})
	}

	if (formAtual.getcomponent('DIASEMANA') != null) {
		formAtual.getcomponent('DIASEMANA').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DIASABONO') != null) {
		formAtual.getcomponent('DIASABONO').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('TIPORECIBO') != null) {
		formAtual.getcomponent('TIPORECIBO').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DIASFERIAS') != null) {
		formAtual.getcomponent('DIASFERIAS').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('INICPROGFERIAS') != null) {
		formAtual.getcomponent('INICPROGFERIAS').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DESCONTPARCELA') != null) {
		formAtual.getcomponent('DESCONTPARCELA').change(HabilitarDesabilitarCampos);
	}

	HabilitarDesabilitarCampos();

	function HabilitarDesabilitarCampos() {
		formAtual = FormManager.byname('TnFpaDMProgFerias', '');

		formAtual.setenabled('DATARETORNOFERIAS', formAtual.getvalue('DIASEMANA') > 0);
		formAtual.setenabled('DATAABONO', (formAtual.getvalue('DIASABONO') != 0) && (formAtual.getvalue('TIPORECIBO') == 1));

		var AAtivar = (formAtual.getvalue('TIPORECIBO') == 1);

		formAtual.setenabled('DIASFERIAS', AAtivar);
		formAtual.setenabled('DIASABONO', AAtivar);
		formAtual.setenabled('PAGAADTO13', AAtivar);
		formAtual.setenabled('DATAPGTO', AAtivar);
		formAtual.setenabled('DESCADTO', AAtivar);
		formAtual.setenabled('DESCONTPARCELA', AAtivar);
		formAtual.setenabled('DIASPREMIO', AAtivar);

		AAtivar = (formAtual.getvalue('DIASFERIAS') > 0);
		formAtual.setenabled('DESCPARVALE', AAtivar);


		var adate = formAtual.getvalue('INICPROGFERIAS') + " 00:00:00";
		var msec = Date.parse(adate);
		var d = new Date(msec);
		if (document.getElementById("demo") != null) {
			document.getElementById("demo").innerHTML = d.getDay();
		}
		AAtivar = (d.getDay() <= 15) && (formAtual.getvalue('DIASFERIAS') > 20);

		formAtual.setenabled('DESCTAXASIND', AAtivar);
		formAtual.setrequired('DESCTAXASIND', AAtivar);

		AAtivar = (formAtual.getvalue('TIPORECIBO') == 1) && (formAtual.getvalue('DESCONTPARCELA') == 1);
		formAtual.setenabled('NUMEROPARCELA', AAtivar);
		formAtual.setenabled('COMPETINICIAL', AAtivar);
	}


})