FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMQtdeVTransp', '');

	$("#dataGridConteudoTnFpaDMQtdeVTranspDet").dxDataGrid({
		onContentReady: function () {
			atualizarTotalizadores();
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMQtdeVTranspDet').refresh();
	});

	function atualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let codigoEscalaVT = formAtual.getvalue('CODIGOESCVT');
		let compet = moment(formAtual.getvalue('COMPET'), 'YYYY-MM-DD').format('DD/MM/YYYY');

		if ((codigoEmpresa) && (codigoFuncContr) && (codigoEscalaVT) && (compet)) {
			let params = JSON.stringify({
				"CODIGOEMPRESA": codigoEmpresa,
				"CODIGOFUNCCONTR": codigoFuncContr,
				"CODIGOESCVT": codigoEscalaVT,
				"COMPET": compet
			});

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMQtdeVTranspDet', 'GetValoresTotalizadoresCloudAjax', params, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_wdgQtde')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.QTDEPASSE;
					$('#widget_wdgValor')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.VALORPASSE;
				}
			});
		}
	}
});

function actCalcularVTExecute(sender) {
	win = AbrirProcesso("TnfpaDPCalculoVtNP", true);
	win.focus();
}
