FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMReciboFerias', '');
	let formDiasDescon = FormManager.byname('TnFpaDMReciboFeriasDiasDescon', '');

	function execDatasFinalFerias() {
		if ([FormState.cadInsert, FormState.cadAlterando].includes(formAtual.estado)) {
			let dataFinalFeriasOld = formAtual.getvalue('DATAFINALFERIAS');

			BuscarDataFinalFerias().then(() => {
				if (dataFinalFeriasOld != formAtual.getvalue('DATAFINALFERIAS')) {
					setDataRetornoFerias(formAtual.getvalue('DATAFINALFERIAS'));
				}
			})
		}
	}

	formDiasDescon.AfterModal = formDiasDescon.AfterDelete = () => {
		let dataFinalFeriasOld = formAtual.getvalue('DATAFINALFERIAS');

		setDataAbono();
		BuscarDataFinalFerias().then(() => {
			if (dataFinalFeriasOld != formAtual.getvalue('DATAFINALFERIAS')) {
				setDataRetornoFerias(formAtual.getvalue('DATAFINALFERIAS')).then(() => {
					setTimeout(() => {
						formAtual.executeAction('actDataSetPostExecute');
					}, 300);
				});
			}
		});
	}

	$("#dataGridConteudoTnFpaDMFeriasEvento").dxDataGrid({
		onContentReady: function () {
			AtualizarTotalizadores();
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMFeriasEvento').refresh();
	})

	const subscriptionFieldList0 = formAtual.afterCreateStaticFields.subscribe(() => {
		if ((formAtual.getcomponent('DATAINICIAL')) && (formAtual.getcomponent('DATAINICIALFERIAS'))) {
			subscriptionFieldList0.unsubscribe();

			formAtual.getcomponent('DATAINICIAL').blur(() => {
				BuscarDiasFerias();
				carregarDadosProgFerias();
			});

			formAtual.getcomponent('DATAINICIALFERIAS').blur(() => {
				execDatasFinalFerias();
			});
		}
	});

	const subscriptionFieldList1 = formAtual.afterCreateStaticFields.subscribe(() => {
		if ((formAtual.getcomponent('DIASFERIAS')) && (formAtual.getcomponent('DIASABONO'))) {
			subscriptionFieldList1.unsubscribe();

			formAtual.getcomponent('DIASFERIAS').blur(() => {
				execDatasFinalFerias();
			});

			formAtual.getcomponent('DIASABONO').blur(() => {
				execDatasFinalFerias();
			});
		}
	});

	function BuscarDiasFerias() {
		if (formAtual.estado === FormState.cadInsert) {
			let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
			let dataInicial = moment(formAtual.getvalue('DATAINICIAL'), 'YYYY-MM-DD').format('DD/MM/YYYY');
			if (dataInicial === 'Invalid date') return;

			formAtual.getvalueLookup('DATAINICIAL', 'DATAFINAL').done((data) => {
				let dataFinal = moment(data, 'MM/DD/YYYY').toDate();
				let dataInicialFerias = moment(formAtual.getvalue('DATAINICIALFERIAS'), 'YYYY-MM-DD').toDate();

				let dataAfast = moment((dataFinal > dataInicialFerias) ? dataInicialFerias : dataFinal).format('DD/MM/YYYY');
				dataInicialFerias = moment(dataInicialFerias).format('DD/MM/YYYY');

				if ((codigoEmpresa) && (codigoFuncContr) && (dataInicialFerias) && (dataInicial) && (dataAfast)) {
					$achave = `${codigoEmpresa};${codigoFuncContr};${dataInicialFerias};${dataInicial};${dataAfast}`;

					AJaxCadastroExecuteMethodGetProperty('TnFpaDMReciboFerias', 'BuscarDiasFeriasCloudAjax', $achave, '', (retorno) => {
						if ((retorno.data.result) && (diasInteirosDireito(retorno.data.result))) {
							formAtual.setvalue('DIASFERIAS', retorno.data.result);
						} else {
							formAtual.setvalue('DIASFERIAS', 0);
						}
					});
				}
			});
		}
	}

	function diasInteirosDireito(diasDireito) {
		if (Number.isInteger(diasDireito)) {
			return true;
		} else {
			criarDialogOk(`Funcionário tem direito a ${diasDireito} dias de férias, 
						   favor informar um número inteiro de dias imediatamente superior
						   aos dias de direito ou utilizar a rotina de férias coletivas.`, 'Atenção', () => {formAtual.getcomponent('DATAINICIALFERIAS').focus()});

			return false;
		}
	}

	function carregarDadosProgFerias() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let dataInicial = moment(formAtual.getvalue('DATAINICIAL'), 'YYYY-MM-DD').format('DD/MM/YYYY');

		if ((codigoEmpresa) && (codigoFuncContr) && (dataInicial)) {
			let params = JSON.stringify({
				"CODIGOEMPRESA": codigoEmpresa,
				"CODIGOFUNCCONTR": codigoFuncContr,
				"DATAINICIAL": dataInicial
			});

			KTApp.blockPage();
			AJaxCadastroExecuteMethodGetProperty('TnFpaDMReciboFerias', 'CarregarDadosProgFeriasAjax', params, '', (retorno) => {
				if (retorno.data.result.totalcount > 0) {
					criarDialogSimNao('Existe Programação de Férias para este funcionário, deseja importá-la?', 'Confirmação', () => {
						formAtual.fields.forEach((field) => {
							if (retorno.data.result.hasOwnProperty(field.nome)) {
								field.setvalue(retorno.data.result[field.nome]);
							}
						});
					});
				}
			});
			KTApp.unblockPage();
		}
	}

	//#region Validação Dias a Desconsiderar
	$("#framemodal").on("load", function () {
		const contentWindow = this.contentWindow;
		contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal, items) => {
			const formDiasDescon = FormManagerModal.byname('TnFpaDMReciboFeriasDiasDescon', '');
			formDiasDescon.BeforePost = function () {
				let DataDesconsiderar = moment(formDiasDescon.getvalue('DATA'), 'YYYY-MM-DD').format('DD/MM/YYYY');
				let DataInicialFerias = moment(formAtual.getvalue('DATAINICIALFERIAS'), 'YYYY-MM-DD').format('DD/MM/YYYY');
				let DataFinalFerias = moment(formAtual.getvalue('DATARETORNOFERIAS'), 'YYYY-MM-DD').format('DD/MM/YYYY');

				if ((DataInicialFerias) && (DataFinalFerias) && (DataDesconsiderar)) {
					$achave = `'${DataDesconsiderar}'; '${DataInicialFerias}'; '${DataFinalFerias}'`;
					return new Promise((resolve, reject) => {
						AJaxCadastroExecuteMethodGetProperty('TnFpaDMReciboFeriasDiasDescon', 'ValidarDataDesconsiderarCloud', $achave, '', (retorno) => {
							if (retorno.data.result.DataDesconsiderarValido == 'Não') {
								qNotifier.error(`Data(s) a Desconsiderar:\n${DataDesconsiderar}\nFora do Período de Férias!`);
								reject();
							}
							else
								resolve();
						})
					})
				}
			}
		});
	});
	//#endregion

	async function setDataAbono() {
		let Executor = new nExpressionExecutor();
		const values = formAtual.getValues();
		let params = `${values.CODIGOEMPRESA},${values.CODIGOFUNCCONTR},'${values.DATAINICIAL}','${values.DATAINICIALFERIAS}','${values.DIASFERIAS}','false'`;
		return Executor.execute(`EXTERNO("PEGARDATAFINALABONO", [${params}])`)
			.then((result) => {
				formAtual.setvalue('DATAABONO', result);
				KTApp.unblockPage();
			})
			.catch(() => {
				KTApp.unblockPage();
			});
	}

	//#region Execução Expressão Data Retorno
	async function setDataRetornoFerias(DATAFINALFERIAS) {
		let Executor = new nExpressionExecutor();
		const values = formAtual.getValues();
		let params = `${values.CODIGOEMPRESA},${values.CODIGOFUNCCONTR},'${values.DATAINICIALFERIAS}','${DATAFINALFERIAS}','${values.DATAABONO || 0}','${values.DIASABONO}'`;
		Executor.execute(`EXTERNO("DATARETORNOFERIAS", [${params}])`)
			.then((result) => {
				formAtual.setvalue('DATARETORNOFERIAS', result);
				KTApp.unblockPage();
			})
			.catch(() => {
				KTApp.unblockPage();
			});
	}
	//#endregion

	//#region Set Data Final Ferias
	BuscarDataFinalFerias = () => {
		return new Promise((resolve) => {
			let CodigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			let CodigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
			let SeqReciboFerias = formAtual.getvalue('SEQRECIBOFERIAS');
			let DiasFerias = formAtual.getvalue('DIASFERIAS');
			let DiasAbono = formAtual.getvalue('DIASABONO');
			let DataInicial = moment(formAtual.getvalue('DATAINICIAL'), 'YYYY-MM-DD').format('DD/MM/YYYY');
			let DataInicialFerias = moment(formAtual.getvalue('DATAINICIALFERIAS'), 'YYYY-MM-DD').format('DD/MM/YYYY');

			if ((CodigoEmpresa) && (CodigoFuncContr) && (SeqReciboFerias) && (DiasFerias) && (DiasAbono) && (DataInicial) && (DataInicialFerias)) {
				$achave = `${CodigoEmpresa}; ${CodigoFuncContr}; ${SeqReciboFerias}; ${DataInicial}; ${DataInicialFerias}; ${DiasFerias}; ${DiasAbono};`

				AJaxCadastroExecuteMethodGetProperty('TnFpaDMReciboFerias', 'BuscarDataFinalFeriasCloudAjax', $achave, '', (retorno) => {
					if (retorno.data.result.DATAFINALFERIAS) {
						formAtual.setvalue('DATAFINALFERIAS', retorno.data.result.DATAFINALFERIAS);
					}
					resolve();
				});
			}
		})
	}
	//#endregion

	//#region Habilita/Desabilita Campos 
	if (formAtual.getcomponent('DIASEMANA') != null) {
		formAtual.getcomponent('DIASEMANA').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DIASABONO') != null) {
		formAtual.getcomponent('DIASABONO').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('TIPORECIBO') != null) {
		formAtual.getcomponent('TIPORECIBO').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DIASFERIAS') != null) {
		formAtual.getcomponent('DIASFERIAS').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DATAINICIALFERIAS') != null) {
		formAtual.getcomponent('DATAINICIALFERIAS').change(HabilitarDesabilitarCampos);
	}

	if (formAtual.getcomponent('DESCONTPARCELA') != null) {
		formAtual.getcomponent('DESCONTPARCELA').change(HabilitarDesabilitarCampos);
	}

	HabilitarDesabilitarCampos();

	function HabilitarDesabilitarCampos() {
		formAtual = FormManager.byname('TnFpaDMReciboFerias', '');

		formAtual.setenabled('DATARETORNOFERIAS', formAtual.getvalue('DIASEMANA') > 0);
		formAtual.setenabled('DATAABONO', (formAtual.getvalue('DIASABONO') != 0) && (formAtual.getvalue('TIPORECIBO') == 1));

		var AAtivar = (formAtual.getvalue('TIPORECIBO') == 1);

		formAtual.setenabled('DIASFERIAS', AAtivar);
		formAtual.setenabled('DIASABONO', AAtivar);
		formAtual.setenabled('PAGAADTO13', AAtivar);
		formAtual.setenabled('DATAPGTO', AAtivar);
		formAtual.setenabled('DESCADTO', AAtivar);
		formAtual.setenabled('DESCONTPARCELA', AAtivar);
		formAtual.setenabled('DIASPREMIO', AAtivar);

		AAtivar = (formAtual.getvalue('DIASFERIAS') > 0);
		formAtual.setenabled('DESCPARVALE', AAtivar);


		var adate = formAtual.getvalue('DATAINICIALFERIAS') + " 00:00:00";
		var msec = Date.parse(adate);
		var d = new Date(msec);
		if (document.getElementById("demo") != null) {
			document.getElementById("demo").innerHTML = d.getDay();
		}
		AAtivar = (d.getDay() <= 15) && (formAtual.getvalue('DIASFERIAS') > 20);

		formAtual.setenabled('DESCTAXASIND', AAtivar);
		formAtual.setrequired('DESCTAXASIND', AAtivar);

		AAtivar = (formAtual.getvalue('TIPORECIBO') == 1) && (formAtual.getvalue('DESCONTPARCELA') == 1);
		formAtual.setenabled('NUMEROPARCELA', AAtivar);
		formAtual.setenabled('COMPETINICIAL', AAtivar);
	}
	//#endregion

	function AtualizarTotalizadores() {
		let codigoEmpresa, codigoFuncContr, dataInicial, dataInicialFerias;
		codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		dataInicial = formAtual.getvalue('DATAINICIAL');
		dataInicialFerias = formAtual.getvalue('DATAINICIALFERIAS');
		seqReciboFerias = formAtual.getvalue('SEQRECIBOFERIAS');

		if ((codigoEmpresa) && (codigoFuncContr) && (dataInicial) && (dataInicialFerias) && (seqReciboFerias)) {
			$achave = codigoEmpresa + ';' + codigoFuncContr + ';' + dataInicial + ';' + dataInicialFerias + ';' + seqReciboFerias;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMFeriasEvento', 'GetValoresTotalizadoresCloudAjax', $achave, '', (retorno) => {
				if (retorno.data.result) {
					let ListaTotalizadores = retorno.data.result.split(";");

					$('#widget_Widget7')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = ListaTotalizadores[0];
					$('#widget_Widget8')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = ListaTotalizadores[1];
					$('#widget_Widget9')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = ListaTotalizadores[2];
					$('#widget_Widget10')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = ListaTotalizadores[3];
					$('#widget_Widget11')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = ListaTotalizadores[4];
				}
			});
		}
	}

	formAtual.afterCreateGridConteudo.subscribe(function () {
		const grid = dxDataGrid.getInstance('#dataGridConteudoTnFpaDMFeriasEvento');
		if (grid) grid.refresh()
	})

	formAtual.afterDelete.subscribe(() => {
		$('#widget_Widget7')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_Widget8')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_Widget9')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_Widget10')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_Widget11')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
	});

})