FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMReciboIntermitente', '');
	let nomeRelatorio = 'nfpaRREnvelPgtoGraficoIntermitente';

	formAtual.AfterLoadDataSubject.subscribe(function () {
		formAtual.getcomponent('CODIGOCONVOCACAO').blur(() => {
			let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			let codigoConvocacao = formAtual.getvalue('CODIGOCONVOCACAO');
			if ((codigoEmpresa) && (codigoConvocacao)) {
				buscarDatasConvocacao(codigoEmpresa, codigoConvocacao)
					.then((retorno) => {
						let datas = JSON.parse(retorno);
						configurarCompet(datas);
						configurarDataPgto(datas);
						configurarDiasCalculo(datas);

						KTApp.unblockPage();
					});
			}
		});

		formAtual.getcomponent('COMPET').blur(() => {
			let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			let codigoConvocacao = formAtual.getvalue('CODIGOCONVOCACAO');
			if ((codigoEmpresa) && (codigoConvocacao)) {
				buscarDatasConvocacao(codigoEmpresa, codigoConvocacao)
					.then((retorno) => {
						let datas = JSON.parse(retorno);
						configurarDiasCalculo(datas);

						KTApp.unblockPage();
					});
			}
		});
	});

	function configurarCompet(datas) {
		let mesmaCompet = startOfTheMonth(datas.DataInicial) === startOfTheMonth(datas.DataFinal);
		formAtual.fieldbyName('COMPET').setenabled(!mesmaCompet);
		if ((mesmaCompet) && (!formAtual.getvalue('COMPET')))
			formAtual.setvalue('COMPET', startOfTheMonth(datas.DataInicial));
	}

	function configurarDataPgto(datas) {
		if ((!formAtual.getvalue('DATAPGTO')) && (startOfTheMonth(datas.DataFinal) === startOfTheMonth(formAtual.getvalue('COMPET'))))
			formAtual.setvalue('DATAPGTO', datas.DataFinal);
	}

	function configurarDiasCalculo(datas) {
		if ([FormState.cadInsert, FormState.cadAlterando].includes(formAtual.estado)) {
			let dataInicial = moment(datas.DataInicial, 'DD/MM/YYYY').format('YYYY-MM-DD');
			let dataFinal = moment(datas.DataFinal, 'DD/MM/YYYY').format('YYYY-MM-DD');

			if (datas.DataInicial < formAtual.getvalue('COMPET')) {
				dataInicial = moment(formAtual.getvalue('COMPET'), 'YYYY-MM-DD');
			}
			if (datas.DataFinal > endOfTheMonth(formAtual.getvalue('COMPET'))) {
				dataFinal = moment(endOfTheMonth(formAtual.getvalue('COMPET')), 'DD/MM/YYYY').format('YYYY-MM-DD');
			}

			formAtual.setvalue('DIASCALCULO', daysBetween(new Date(dataInicial), new Date(dataFinal)) + 1);
		}
	}

	async function buscarDatasConvocacao(codigoEmpresa, codigoConvocacao) {
		let Executor = new nExpressionExecutor();
		return await Executor.execute(`EXTERNO("BUSCARDATASCONVOCACAO",[${codigoEmpresa},${codigoConvocacao}])`);
	}

	function startOfTheMonth(data) {
		let mask = data.includes('/') ? 'DD/MM/YYYY' : 'YYYY-MM-DD';

		let date = (new Date(moment(data, mask).add(1, 'days').format('YYYY-MM-DD')));
		return moment(new Date(date.getFullYear(), date.getMonth(), 1), 'YYYY-MM-DD').format('DD/MM/YYYY');
	}

	function endOfTheMonth(data) {
		let mask = data.includes('/') ? 'DD/MM/YYYY' : 'YYYY-MM-DD';

		let date = (new Date(moment(data, mask).add(1, 'months').subtract(1, 'days').format('YYYY-MM-DD')));
		return moment(date, 'YYYY-MM-DD').format('DD/MM/YYYY');
	}

	function daysBetween(firstDate, secondDate) {
		const oneDay = 24 * 60 * 60 * 1000;
		return Math.round(Math.abs((firstDate - secondDate) / oneDay));
	}

	$("#dataGridConteudoTnFpaDMIntermitenteEventoTnFpaDMReciboIntermitente").dxDataGrid({
		onContentReady: function() {
			AtualizarTotalizadores();
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMIntermitenteEventoTnFpaDMReciboIntermitente').refresh();
	})

	function AtualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let codigoConvocacao = formAtual.getvalue('CODIGOCONVOCACAO');
		let codigoTipoCalc = formAtual.getvalue('CODIGOTIPOCALC');
		let seqRecibo = formAtual.getvalue('SEQRECIBOINTERMITENTE');
		let compet = moment(formAtual.getvalue('COMPET'), 'YYYY-MM-DD').format('DD/MM/YYYY');

		if ((codigoEmpresa) && (codigoFuncContr) && (codigoConvocacao) && (codigoTipoCalc) && (seqRecibo) && (compet)) {
			$achave = `${codigoEmpresa};${codigoFuncContr};${codigoConvocacao};${codigoTipoCalc};${seqRecibo};"${compet}"`;

			KTApp.blockPage();
			AJaxCadastroExecuteMethodGetProperty('TnFpaDMIntermitenteEvento', 'GetValoresTotalizadoresCloudAjax', $achave, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_wdgBaseIRRFNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText       = retorno.data.result.IRRFNormal;
					$('#widget_wdgBaseINSSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText       = retorno.data.result.INSSNormal;
					$('#widget_wdgBaseFGTSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText       = retorno.data.result.FGTSNormal;
					$('#widget_wdgBaseIRRF13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText           = retorno.data.result.IRRF13;
					$('#widget_wdgBaseINSS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText           = retorno.data.result.INSS13;
					$('#widget_wdgBaseFGTS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText           = retorno.data.result.FGTS13;
					$('#widget_wdgBaseIRRFFerias')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText       = retorno.data.result.IRRFFerias;
					$('#widget_wdgBaseIRRFLucro')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText        = retorno.data.result.IRRFLucro;
					$('#widget_wdgBaseIRRFDependenteIR')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.IRRFDependente;
					$('#widget_wdgBaseINSSDependenteIR')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.INSSDependente;
					$('#widget_wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText            = retorno.data.result.Proventos;
					$('#widget_wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText            = retorno.data.result.Descontos;
					$('#widget_wdgLiquidos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText             = retorno.data.result.Liquido;
					$('#widget_wdgSalarioBase')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText          = retorno.data.result.SalarioBase;
				}
			});
			KTApp.unblockPage();
		}
	}

	FormManager.setReportCustomEvent({
		Class: 'TnFpaDMReciboIntermitente',
		reportName: nomeRelatorio,
		fn: ({ Class, Alias, Tipo, NameItem, Text }) => {
			let params = CadastroGetImputData(formAtual);
			params.pCodigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			params.pCodigoEmpresaSelecao = formAtual.getvalue('CODIGOEMPRESA');
			params.pCodigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
			params.pCodigoConvocacao = formAtual.getvalue('CODIGOCONVOCACAO');
			params.pCompet = formAtual.getvalue('COMPET');

			if ((params.pCodigoEmpresa) && (params.pCodigoEmpresaSelecao) && (params.pCodigoFuncContr) &&
				(params.pCodigoConvocacao) && (params.pCompet))
				DoExecuteReportWithParams(nomeRelatorio, params);
			else
				window.open("Relatorio?Scope=" + JSON.stringify({Class: nomeRelatorio}), '_blank')
		} 
	})
})
