FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMRefeicaoQtde', '');

	$("#dataGridConteudoTnFpaDMRefeicaoQtdeDet").dxDataGrid({
		onContentReady: function () {
			atualizarTotalizadores();
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMRefeicaoQtdeDet').refresh();
	});

	function atualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let codigoEscalaRef = formAtual.getvalue('CODIGOESCALAREFEICAO');
		let competRef = moment(formAtual.getvalue('COMPETREFEICAO'), 'YYYY-MM-DD').format('DD/MM/YYYY');

		if ((codigoEmpresa) && (codigoFuncContr) && (codigoEscalaRef) && (competRef)) {
			let params = JSON.stringify({
				"CODIGOEMPRESA": codigoEmpresa,
				"CODIGOFUNCCONTR": codigoFuncContr,
				"CODIGOESCALAREFEICAO": codigoEscalaRef,
				"COMPETREFEICAO": competRef
			});

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMRefeicaoQtdeDet', 'GetValoresTotalizadoresCloudAjax', params, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_wdgQtde')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.QTDEREFEICAO;
					$('#widget_wdgValor')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.VALORREFEICAO;
				}
			});
		}
	}
});

function actCalcularVTExecute(sender) {
	win = AbrirProcesso("TnFpaDPCalculoRefeicao", true);
	win.focus();
}
