FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMRescisao', '');
	var DynamicImport = FormManager.getUtil('DynamicImport');

	const AtualizarTotalizadores = DynamicImport.Import('PageScripts/nFpa/RescisaoTotalizadores', 'AtualizarTotalizadores');
	const LimparTotalizadores = DynamicImport.Import('PageScripts/nFpa/RescisaoTotalizadores', 'LimparTotalizadores');

	$('#ctrlAVISOPREVIO').change(forcarLimpezaDataAvPrevio);
	$('#ctrlCODIGOFUNCCONTR').change(ConfigurarLabelData);
	$('#ctrlCODIGOFUNCCONTR').blur(ConfigurarLabelData);
	$('#ctrlCOMPLEMENTAR').change(CarregarCamposComplementares);
	$('#ctrlCOMPLEMENTAR').blur(CarregarAvisoPrevio);
	$('#ctrlDATAPGTORESC').siblings().find('input').blur(DataPagamentoRevisado);

	$("#dataGridConteudoTnFpaDMRescisaoEventoTnFpaDMRescisao").dxDataGrid({
		onContentReady: function () {
			AtualizarTotalizadores
				.then((method) => {
					method(formAtual);
				});
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMRescisaoEventoTnFpaDMRescisao').refresh();
	})

	formAtual.afterDelete.subscribe(() => {
		LimparTotalizadores
			.then((method) => {
				method();
			});
	});

	function forcarLimpezaDataAvPrevio() {
		let avisoPrevio = document.getElementById('ctrlAVISOPREVIO').value;
		let dataCampo = formAtual.getvalue('DATAAVPREVIO');

		if (avisoPrevio == 3 && dataCampo != '') {
			document.getElementById("ctrlDATAAVPREVIO").value = null;
		}
	}

	function ConfigurarLabelData() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');

		if ((codigoEmpresa) && (codigoFuncContr)) {
			$achave = `${codigoEmpresa};${codigoFuncContr}`;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMRescisao', 'ConfigurarLabelDataCloudAjax', $achave, '', (retorno) => {
				if (retorno.data.result) {
					document.getElementById('widget_valor_Widget3').innerHTML = retorno.data.result;
					document.getElementById('widget_valor_Widget3').style.color = "rgb(255, 0, 0)";
				} else {
					document.getElementById('widget_valor_Widget3').innerHTML = null;
				}
			});
		}
	}

	function CarregarCamposComplementares() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let complementar = formAtual.getvalue('COMPLEMENTAR');

		if ((codigoEmpresa) && (codigoFuncContr) && (complementar > 1)) {
			$achave = `${codigoEmpresa};${codigoFuncContr};${complementar}`;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMRescisao', 'CarregarCamposComplementaresAjax', $achave, '', requestDataSucesso);

			function requestDataSucesso(retorno) {
				formAtual.setvalue('TIPORESCISAO',   retorno.data.result.tiporescisao);
				formAtual.setvalue('AVISOPREVIO',    retorno.data.result.avisoprevio);
				formAtual.setvalue('CODIGOCAUSA',    retorno.data.result.codigocausa);
				formAtual.setvalue('CODIGOSAQUE',    retorno.data.result.codigosaque);
				formAtual.setvalue('TIPOAFASTSEFIP', retorno.data.result.tipoafastsefip);
				formAtual.setvalue('TIPOAFASTCAGED', retorno.data.result.tipoafastcaged);
				formAtual.setvalue('TIPOAFASTRAIS',  retorno.data.result.tipoafastrais);
				formAtual.setvalue('DATAAVPREVIO',   retorno.data.result.dataavprevio);
				formAtual.setvalue('INICIOCONTAGEM', retorno.data.result.iniciocontagem);
				formAtual.setvalue('DATARESC',       retorno.data.result.dataresc);
				formAtual.setvalue('DIASAVISOTRAB',  retorno.data.result.diasavisotrab);
				formAtual.setvalue('DIASAVINDEN',    retorno.data.result.diasavinden);
				formAtual.setvalue('DATAAVISOINDEN', retorno.data.result.dataavisoinden);
				formAtual.setvalue('DIASAVREAV',     retorno.data.result.diasavreav);
				formAtual.setvalue('DATAAVISOREAV',  retorno.data.result.dataavisoreav);
				formAtual.setvalue('DIASTRAB',       retorno.data.result.diastrab);
				formAtual.setvalue('SALFINAL',       retorno.data.result.salfinal);
				formAtual.setvalue('FGTSMESANT',     retorno.data.result.fgtsmesant);
				formAtual.setvalue('SALDOFGTS',	     retorno.data.result.saldofgts);

				formAtual.triggerExpressions();
			}
		}
	}

	function CarregarAvisoPrevio() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');

		if ((formAtual.estado == FormState.cadInsert) && (formAtual.getvalue('TIPORESCISAO') == 1) && (formAtual.getvalue('COMPLEMENTAR') == 1)) {
			if ((codigoEmpresa) && (codigoFuncContr)) {
				$achave = `${codigoEmpresa};${codigoFuncContr}`;

				KTApp.blockPage();
				AJaxCadastroExecuteMethodGetProperty('TnFpaDMRescisao', 'CarregarAvisoPrevioAjax', $achave, '', (retorno) => {
					if (retorno.data.result) {
						criarDialogSimNao('Importar rescisão do Aviso Prévio?', 'Confirmação', () => {
							let ignoredFields = ['TIPORESCISAO'];

							formAtual.fields.forEach((field) => {
								if ((!ignoredFields.includes(field.nome)) && (retorno.data.result.hasOwnProperty(field.nome)))
									field.setvalue(retorno.data.result[field.nome]);
							});
						});
					}
				});
				KTApp.unblockPage();
			}
		}
	}

	function DataPagamentoRevisado() {
		var Executor = new nExpressionExecutor();
		const values = formAtual.getValues();
		let params = `${values.CODIGOEMPRESA},${values.CODIGOFUNCCONTR},${values.AVISOPREVIO},${values.TIPORESCISAO},${values.CODIGOPERCALCULO},"${values.DATARESC}"`;

		Executor.execute(`EXTERNO("PEGARDATAPGTORESC", [${params}])`)
			.then((dataSugerida) => {
				if (dataSugerida != formAtual.getvalue('DATAPGTORESC')) {
					formAtual.setvalue('DATAPAGTOREVISADO', '1')
				}
			});
	}
});
