FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMRescisaoComplDissidio', '');
	var DynamicImport = FormManager.getUtil('DynamicImport');

	const AtualizarTotalizadores = DynamicImport.Import('PageScripts/nFpa/RescisaoTotalizadores', 'AtualizarTotalizadores');
	const LimparTotalizadores = DynamicImport.Import('PageScripts/nFpa/RescisaoTotalizadores', 'LimparTotalizadores');

	$(`button[data-action-name="actCalcularRescisao"]`).hide();

	$("#dataGridConteudoTnFpaDMRescisaoEventoTnFpaDMRescisaoComplDissidio").dxDataGrid({
		onContentReady: function () {
			AtualizarTotalizadores
				.then((method) => {
					method(formAtual);
				});
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMRescisaoEventoTnFpaDMRescisaoComplDissidio').refresh();
	});

	formAtual.afterDelete.subscribe(function () {
		LimparTotalizadores
			.then((method) => {
				method();
			});
	});

	const subs = formAtual.AfterLoadDataSubject.subscribe(() => {
		let filtros = {};
		filtros['CODIGOEMPRESA'] = WizardManager.context.Params.PCODIGOEMPRESA;
		filtros['CODIGOSINDDISSIDIOEMP'] = WizardManager.context.Params.PCODIGOSINDDISSIDIO;

		FormManager.loadCadastro({
			_ACadastro: 'TnFpaDMRescisaoComplDissidio', 
			_AAlias: '', 
			_AFiltros: filtros
		}).then((retorno) => {
			const state = (retorno.data.StatusRegistro === 'OK') ? FormState.cadNavegando : FormState.cadInsert;
			formAtual.changeState(state);
			formAtual.focusFirstField();
		});

		subs.unsubscribe();
	});
});
