FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMResilicao', '');

	$("#dataGridConteudoTnFpaDMResilicaoEventoTnFpaDMResilicao").dxDataGrid({
		onContentReady: function () {
			atualizarTotalizadores();
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		formAtual.changeState(FormState.cadNavegando);
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMResilicaoEventoTnFpaDMResilicao').refresh();
	})

	formAtual.afterDelete.subscribe(() => {
		limparTotalizadores();
	});

	function atualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let seq = formAtual.getvalue('SEQ');

		if ((codigoEmpresa) && (codigoFuncContr) && (seq)) {
			let params = `${codigoEmpresa};${codigoFuncContr};${seq}`;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMResilicaoEvento', 'GetValoresTotalizadoresCloudAjax', params, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_wdgBaseIRRFNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.IRRFNormal;
					$('#widget_wdgBaseINSSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.INSSNormal;
					$('#widget_wdgBaseFGTSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.FGTSNormal;
					$('#widget_wdgBaseIRRF13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.IRRF13;
					$('#widget_wdgBaseINSS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.INSS13;
					$('#widget_wdgBaseFGTS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.FGTS13;
					$('#widget_wdgBaseIRRFFerias')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.IRRFFerias;
					$('#widget_wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.Proventos;
					$('#widget_wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.Descontos;
					$('#widget_wdgLiquidos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.Liquido;
				}
			});
		}
	}

	function limparTotalizadores() {
		$('#widget_wdgBaseIRRFNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseINSSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseFGTSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseIRRF13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseINSS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseFGTS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseIRRFFerias')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgLiquidos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
	}
});
