const tcsContribSindical       = '1';
const tcsTaxaAssistencial      = '2';
const tcsCusteioConfederativo  = '3';
const tcsMensalidadeSindical   = '4';
const tcsReversaoSalarial      = '5';
const tcsPremioAdicComerciario = '6';

FormManager.afterCreateAllForms.subscribe(function () {
	let formMaster = FormManager.byname('TnFpaDMSindicato', '');
	let formConvencao = FormManager.byname('TnFpaDMSindConvencaoVigencia', '');
	let formSindical = FormManager.byname('TnFpaDMSindContribSindical', '');
	let formTaxaAssist = FormManager.byname('TnFpaDMSindContribTaxaAssistencial', '');
	let formCusteioConfed = FormManager.byname('TnFpaDMSindContribCusteioConfed', '');
	let formMensalidadeSind = FormManager.byname('TnFpaDMSindContribMensalidadeSind', '');
	let formReversaoSalarial = FormManager.byname('TnFpaDMSindContribMensalidadeSind', '');
	let formPremioAdicComerc = FormManager.byname('TnFpaDMSindContribPremioAdicComerc', '');
	let formFeriasAmpliada = FormManager.byname('TnFpaDMFeriasAmpliadaVigencia', '');

	formMaster.AfterLoadDataSubject.subscribe(function () {
		habilitaDesabilitaDetalhes();
		formMaster.getcomponent('PATRONAL').change(habilitaDesabilitaDetalhes);
	});

	formConvencao?.afterCreateGridConteudo.subscribe(() => {
		let gridConvencao = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindConvencaoVigencia'));
		let formAtual = FormManager.byname('TnFpaDMSindConvencao', '');
		gridConvencao.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindConvencao', '', filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridConvencao.refresh();
		});
	});

	formSindical?.afterCreateGridConteudo.subscribe(() => {
		let gridSindical = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindContribSindical'));
		let formAtual = FormManager.byname('TnFpaDMSindContrib', tcsContribSindical);
		gridSindical.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","CONTRIBSIND":"${tcsContribSindical}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindContrib', tcsContribSindical, filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridSindical.refresh();
		});
	});

	formTaxaAssist?.afterCreateGridConteudo.subscribe(() => {
		let gridTaxaAssist = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindContribTaxaAssistencial'));
		let formAtual = FormManager.byname('TnFpaDMSindContrib', tcsTaxaAssistencial);
		gridTaxaAssist.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","CONTRIBSIND":"${tcsTaxaAssistencial}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindContrib', tcsTaxaAssistencial, filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridTaxaAssist.refresh();
		});
	});

	formCusteioConfed?.afterCreateGridConteudo.subscribe(() => {
		let gridCusteioConfed = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindContribCusteioConfed'));
		let formAtual = FormManager.byname('TnFpaDMSindContrib', tcsCusteioConfederativo);
		gridCusteioConfed.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","CONTRIBSIND":"${tcsCusteioConfederativo}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindContrib', tcsCusteioConfederativo, filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridCusteioConfed.refresh();
		});
	});

	formMensalidadeSind?.afterCreateGridConteudo.subscribe(() => {
		let gridMensalidadeSind = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindContribMensalidadeSind'));
		let formAtual = FormManager.byname('TnFpaDMSindContrib', tcsMensalidadeSindical);
		gridMensalidadeSind.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","CONTRIBSIND":"${tcsMensalidadeSindical}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindContrib', tcsMensalidadeSindical, filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridMensalidadeSind.refresh();
		});
	});

	formReversaoSalarial?.afterCreateGridConteudo.subscribe(() => {
		let gridReversaoSalarial = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindContribReversaoSalarial'));
		let formAtual = FormManager.byname('TnFpaDMSindContrib', tcsReversaoSalarial);
		gridReversaoSalarial.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","CONTRIBSIND":"${tcsReversaoSalarial}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindContrib', tcsReversaoSalarial, filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridReversaoSalarial.refresh();
		});
	});

	formPremioAdicComerc?.afterCreateGridConteudo.subscribe(() => {
		let gridPremioAdicComerc = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMSindContribPremioAdicComerc'));
		let formAtual = FormManager.byname('TnFpaDMSindContrib', tcsPremioAdicComerciario);
		gridPremioAdicComerc.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","CONTRIBSIND":"${tcsPremioAdicComerciario}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMSindContrib', tcsPremioAdicComerciario, filter);
			}
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridPremioAdicComerc.refresh();
		});
	});

	formFeriasAmpliada?.afterCreateGridConteudo.subscribe(() => {
		let gridFeriasAmpliada = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMFeriasAmpliadaVigencia'));
		let formAtual = FormManager.byname('TnFpaDMFeriasAmpliada', '');
		gridFeriasAmpliada.option("onRowClick", (row) => {
			const { CODIGOSIND, DATAINICIAL } = row.data;
			if ((CODIGOSIND) && (DATAINICIAL)) {
				const filter = `{"CODIGOSIND":"${CODIGOSIND}","DATAINICIAL":"${moment(DATAINICIAL).format('YYYY-MM-DD')}"}`;
				atualizarDetalhe('TnFpaDMFeriasAmpliada', '', filter);
			}
		});
		formAtual.AfterLoadData = () => {
			dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMFeriasAmpliadaDet')).refresh();
		}

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridFeriasAmpliada.refresh();
		});
	});

	function atualizarDetalhe(formClass, alias, filter) {
		FormManager.loadCadastro({
			_ACadastro: formClass,
			_AAlias: alias,
			_AFiltros: filter
		}).then((retorno) => {
			if (retorno.data.StatusRegistro === 'OK') {
				FormManager.byname(formClass, alias).changeState(FormState.cadNavegando);
			}
		});
	}

	function habilitaDesabilitaDetalhes() {
		if (formMaster.getvalue('PATRONAL') == 1) {
			formConvencao.element.closest('.tab-content').closest('.card').addClass('d-none');
		} else {
			formConvencao.element.closest('.tab-content').closest('.card').removeClass('d-none');
		}
	}
});