FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMTerceiroPgto', '');
	let expressionexecutor = new nExpressionExecutor();

	formAtual.afterDelete.subscribe(() => ZerarTotalizadores());
	formAtual.AfterLoadDataSubject.subscribe(() => {
		ZerarTotalizadores();
		ConfigurarActions();
	});

	function ConfigurarActions() {
		let values = formAtual.getValues();

		$('[data-action-name="nActRecalcular"]').on('click', async () => {
			await expressionexecutor.execute(`EXTERNO("HABILITARPAGTOSPENSAO", [${values.CODIGOEMPRESA},${values.CODIGOTERC},"${values.COMPET}",${values.SEQ},])`).then(function(isEnable){
				$('[data-action-name="nActDetPgtosPensao"]').attr({disabled: isEnable});
			});
		});
		expressionexecutor.execute(`EXTERNO("HABILITATERCEIROUSASERVICOVARIAVEL", [${values.CODIGOTERC}])`).then(function(isEnable){
			$('[data-action-name="nActTerceiroPgtoServicoVariavel"]').attr({disabled: isEnable});
		});
	
		formAtual.getcomponent('GPSORIGEM').blur(HabilitaDesabilitaActeSocial);
		formAtual.getcomponent('COMPET').blur(HabilitaDesabilitaActeSocial);

		HabilitaDesabilitaActeSocial();
	}

	function HabilitaDesabilitaActeSocial(){
		let values = formAtual.getValues();
		expressionexecutor.execute(`AND([IN(${values.GPSORIGEM},[1,3,5,7,9,12,13]),EXTERNO("EMPRESAATENDEFASEAMENTO",[${values.CODIGOEMPRESA},"${values.COMPET}",3])])`).then(function(isEnable){
			$('[data-action-name="actGerar_Evento_eSocial"]').attr({disabled: !isEnable});
		});
	}

	function ZerarTotalizadores() {
		$('#widget_wdgBaseIRRF')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgBaseINSS')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
		$('#widget_wdgLiquido')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
	};
	
	$("#dataGridConteudoTnFpaDMTerceiroPgtoServico").dxDataGrid({
		onContentReady: function () {
			AtualizarTotalizadores();
		}
	});

	function AtualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoterc = formAtual.getvalue('CODIGOTERC');
		let seq = formAtual.getvalue('SEQ');
		let compet = formAtual.getvalue('COMPET');
		const widGets = ['wdgBaseIRRF', 'wdgBaseINSS', 'wdgProventos', 'wdgDescontos', 'wdgLiquido'];

		if ((codigoEmpresa) && (codigoterc) && (seq) && (compet)) {
			$achave = `${codigoEmpresa};${codigoterc};${seq};${compet}`;
			
				AJaxCadastroExecuteMethodGetProperty('TnFpaDMTerceiroPgtoServico', 'GetValoresTotalizadoresCloudAjax', $achave, '', (retorno) => {
					if (retorno.data.result) {					
						$('#widget_wdgBaseIRRF')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorBaseIRRF;
						$('#widget_wdgBaseINSS')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorBaseINSS;
						$('#widget_wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorProventos;
						$('#widget_wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorDescontos;
						$('#widget_wdgLiquido')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorLiquido;
					}
				});			
		} else {			
				widGets.forEach(widGet => {
					widgetManager.get(widGet).setValue({value:'0,00'});															
				})	  			
		}
	}
})