FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMVale', '');

	formAtual.AfterSave.subscribe(() => AtualizarGrid());

	formAtual.AfterLoadDataSubject.subscribe(() => ZerarTotalizadores());

	$("#dataGridConteudoTnFpaDMValeParcela").dxDataGrid({
		onContentReady: function() {
			AtualizarTotalizadores();
		}
	});

    function AtualizarTotalizadores() {
        let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let dataVale = formAtual.getvalue('DATAVALE');
        let seq = formAtual.getvalue('SEQ');

		if ((codigoEmpresa) && (codigoFuncContr) && (seq) && (dataVale)) {
			$achave = `${codigoEmpresa};${codigoFuncContr};${seq};${dataVale}`;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMValeParcela', 'GetValoresTotalizadoresCloudAjax', $achave, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_WidgetDesc')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorDesc;
					$('#widget_WidgetParc')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ValorTotalParc;
				}
			});
		}
	}

	function AtualizarGrid(){
		const grid = dxDataGrid.getInstance('#dataGridConteudoTnFpaDMValeParcela')
			if (grid) grid.refresh();
	}

	function ZerarTotalizadores(){
		if (formAtual.estado === FormState.cadInsert){
			$('#widget_WidgetDesc')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';
			$('#widget_WidgetParc')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '0,00';	
		}
	}
})