FormManager.afterCreateAllForms.subscribe(function () {
    const formProcTrab     = FormManager.byname('TnFpaDMeSocialProcTrab', '');
    const formInfoContrato = FormManager.byname('TnFpaDMProcTrabInfoContratoProcTrabInfoContrato', '');
    const formFuncSalario  = FormManager.byname('TnFpaDMProcTrabFuncSalarioProcTrabFuncSalario', ''); 
    const formDependentes  = FormManager.byname('TnFpaDMProcTrabDependentesProcTrabDependentes', '');  
    const formBaseCalculo  = FormManager.byname('TnFpaDMProcTrabBasesCalculoProcTrabBasesCalculo', ''); 

    const requestDataCarregarNomeTrab = function () {
        let CPFTrab = formProcTrab.getvalue('CPFTRAB');

        if (CPFTrab) {
            $achave = `${CPFTrab};`;
            AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialProcTrab', 'CarregarNomeTrab', $achave, '', requestDataSucessoNomeTrab);
        }
    }

    function requestDataSucessoNomeTrab(retorno) {
        formProcTrab.loadfromdata(retorno.data.result);
    }

    $('.ctrlCPFTRAB').change(() => {
        setTimeout(() => {
            if ([FormState.cadInsert].includes(formProcTrab.estado)) {
                formProcTrab.setvalue('NOMETRAB', null);
                formProcTrab.setvalue('DTNASCTO', null);
                setTimeout(requestDataCarregarNomeTrab());
            }
        });
    });

    const requestDataDependentes = function () {
        let codigoEmpresa = formProcTrab.getvalue('CODIGOEMPRESA')
        let nrProcTrab = formProcTrab.getvalue('NRPROCTRAB');
        let CPFTrab = formProcTrab.getvalue('CPFTRAB');

        if (codigoEmpresa && nrProcTrab && CPFTrab) {
            $AChave = `${codigoEmpresa};${CPFTrab}`;
            $AChaveImp = `${codigoEmpresa};${nrProcTrab};${CPFTrab}`;

            AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialProcTrab', 'ExisteDependentes', $AChave, '', (retorno) => {
                if (retorno.data.result) {
                    bootbox.dialog({
                        message: `Existem cadastros de dependentes vinculados a este CPF. Deseja importar estes cadastros agora?`,
                        title: '',
                        buttons: {
                            Nao: {
                                label: 'Não',
                                className: "btn-cancel",
                                callback: () => { }
                            },
                            Sim: {
                                label: 'Sim',
                                className: "btn-success",
                                callback: () => {
                                    AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialProcTrab', 'ImportarDependentes', $AChaveImp, '', (retorno) => {
                                        if ((formDependentes != null) && (retorno.data.result)) {
                                            formDependentes.executeAction('actDataSetRefreshExecute');
                                        }
                                    })
                                }
                            }
                        }
                    });
                }
            });

        };
    }

    formProcTrab.AfterSave.subscribe(() => {
        requestDataDependentes();
    });

    const requestDataFuncionario = function () {
        let codigoEmpresa = formInfoContrato.getvalue('CODIGOEMPRESA');
        let codigoFuncContr = formInfoContrato.getvalue('CODIGOFUNCCONTR');

        if ((codigoEmpresa) && (codigoFuncContr)) {
            $achave = `${codigoEmpresa};${codigoFuncContr}`;

            AJaxCadastroExecuteMethodGetProperty('TnFpaDMProcTrabInfoContrato', 'CarregarFuncContrato', $achave, '', requestDataSucessoAjax);
        }
    }

    function requestDataSucessoAjax(retorno) {
        formInfoContrato.loadfromdata(retorno.data.result);
    }

    $('.ctrlCODIGOFUNCCONTR').change(() => {
        setTimeout(() => {
            if ([FormState.cadInsert].includes(formInfoContrato.estado)) {
                formInfoContrato.setvalue('MATRICULA', null);
                formInfoContrato.setvalue('CODIGOCARGO', null);
                formInfoContrato.setvalue('DTADM', null);
                formInfoContrato.setvalue('TMPPARC', null);
                formInfoContrato.setvalue('CLAUASSEC', null);
                formInfoContrato.setvalue('TPREGTRAB', null);
                formInfoContrato.setvalue('TPREGPREV', null);
                formInfoContrato.setvalue('CODCATEG', null);
                formInfoContrato.setvalue('DTDESLIG', null);
                formInfoContrato.setvalue('CODIGOCAUSA', null);
                formInfoContrato.setvalue('CATEGORIG', null);
                setTimeout(requestDataFuncionario());
            }
        });
    });

    const requestDataFuncSalario = function () {
        let codigoEmpresa = formInfoContrato.getvalue('CODIGOEMPRESA');
        let codigoFuncContr = formInfoContrato.getvalue('CODIGOFUNCCONTR');
        let nrProcTrab = formInfoContrato.getvalue('NRPROCTRAB');
        let CPFTrab = formInfoContrato.getvalue('CPFTRAB');
        let sequencia = formInfoContrato.getvalue('SEQUENCIA');

        if ((codigoEmpresa) && (codigoFuncContr) && (nrProcTrab) && (CPFTrab) && (sequencia)) {
            $achave = `${codigoEmpresa};${codigoFuncContr};${nrProcTrab};${CPFTrab};${sequencia}`;

            AJaxCadastroExecuteMethodGetProperty('TnFpaDMProcTrabInfoContrato', 'CarregarFuncSalario', $achave, '', requestDataSucessoFuncSalarioAjax);
        }
    }

    function requestDataSucessoFuncSalarioAjax(retorno) {
        if ((formFuncSalario != null) && (retorno.data.result)) {
            formFuncSalario.executeAction('actDataSetRefreshExecute');
        }
    }

    const requestDataBaseCalculo = function () {
        let codigoEmpresa = formInfoContrato.getvalue('CODIGOEMPRESA');
        let codigoFuncContr = formInfoContrato.getvalue('CODIGOFUNCCONTR');
        let nrProcTrab = formInfoContrato.getvalue('NRPROCTRAB');
        let CPFTrab = formInfoContrato.getvalue('CPFTRAB');
        let sequencia = formInfoContrato.getvalue('SEQUENCIA');
        let dataInicial = formInfoContrato.getvalue('COMPINI');
        let dataFinal = formInfoContrato.getvalue('COMPFIM');

        if ((codigoEmpresa) && (codigoFuncContr) && (nrProcTrab) && (CPFTrab) && (sequencia) && (dataInicial) && (dataFinal)) {
            $achave = `${codigoEmpresa};${codigoFuncContr};${nrProcTrab};${CPFTrab};${sequencia};${dataInicial};${dataFinal}`;

            AJaxCadastroExecuteMethodGetProperty('TnFpaDMProcTrabInfoContrato', 'InserirCompetencias', $achave, '', requestDataSucessoBaseCalculoAjax);
        }
    }

    function requestDataSucessoBaseCalculoAjax(retorno) {
        if ((formBaseCalculo != null) && (retorno.data.result)) {
            formBaseCalculo.executeAction('actDataSetRefreshExecute');
        }
    }

    formInfoContrato.AfterSave.subscribe(() => {
        requestDataFuncSalario();
        requestDataBaseCalculo();
    });
});