FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMeSocialXML', '');

	form.AfterLoadDataSubject.subscribe(() => {
		requestXML();
	})

	function requestXML() {
		if (FormManager.FiltroModal.CODIGOEMPRESA && FormManager.FiltroModal.CODIGOESOCIALTRANSACAO) {
			KTApp.blockPage();
			let $achave = `${FormManager.FiltroModal.CODIGOEMPRESA};${FormManager.FiltroModal.CODIGOESOCIALTRANSACAO}`;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialXML', 'BuscarXML', $achave, '', (retorno) => {
				form.setvalue('XML', retorno.data.result);
				form.setvalue('CODIGOEMPRESA', form.getvalue('CODIGOEMPRESA'));
				form.setvalue('CODIGOESOCIALTRANSACAO', form.getvalue('CODIGOESOCIALTRANSACAO'));
				
				if (retorno.data.result.length == 0) {
					criarDialogOk('O XML Gerou Vazio. Verifique se o cadastro relacionado ao evento ainda existe no sistema, caso não exista, exclua esta transação.', 'Atenção');
				}
				
			});
			nActFormatarXMLExecute();
			KTApp.unblockPage();
		}
	}
})

async function actCarregarXMLfield(sd) {
	let uploadFile = (sd.files || [])[0];
	let form = FormManager.byname('TnFpaDMeSocialXML', '');

	if (uploadFile) {
		let file = await prepareFile64(uploadFile);
		let btnsalvar = getBtnSalvar();

		form.fieldbyName("XML").setvalue(atob(file));
		field.componente.trigger('change')
		btnsalvar.removeAttr("disabled");
	}
}

function nActExtrairXMLRetornoExecute() {
	statusPermitido(['3', '4', '7', '8', '9', '10', '11', '12', '14', '15']).then((result) => {
		if (result) {
			let form = FormManager.byname('TnFpaDMeSocialXML', '');
			let field = form.fieldbyName("XMLRETORNO");

			if (field && (field.getvalue().length > 0)) {
				requestEvento(form).then(function(evento) {
					if (evento) {
						let $achave = `${FormManager.FiltroModal.CODIGOEMPRESA};${FormManager.FiltroModal.CODIGOESOCIALTRANSACAO}`;
						AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialXML', 'DescompactarXMLAjax', $achave, '', (retorno) => {
							downloadFileFromData(getNomeArquivo(evento, form.getvalue('CODIGOEMPRESA'), form.getvalue('CODIGOESOCIALTRANSACAO'), 'XMLRETORNO'), 'data:text/xml;charset=utf-8,', retorno.data.result);
						}
					)}
				});
			}
			else {
				qNotifier.error("Xml ainda não processado");
			}
		} else {
			qNotifier.error('O XML não pode ser baixado!');
		}
	});
}

function nActExtrairXMLEnvioExecute() {
	statusPermitido(['3', '4', '6', '7', '8', '9', '10', '11', '12', '14', '15']).then((result) => {
		if (result) {	
			let form = FormManager.byname('TnFpaDMeSocialXML', '');
			let field = form.fieldbyName("XML");
		
			requestEvento(form).then(function(evento) {
				if ((field) && (evento)) {
					let xml = field.getvalue();
					downloadFileFromData(getNomeArquivo(evento, form.getvalue('CODIGOEMPRESA'), form.getvalue('CODIGOESOCIALTRANSACAO'), 'XML'), 'data:text/xml;charset=utf-8,', xml);
				}
			});
		} else {
			qNotifier.error('O XML não pode ser baixado!');
		}
	})
} 

function requestEvento(form) {
	return new Promise(function (resolve, reject) {
		if (form.getvalue('XML')) {
			let $achave = `${form.getvalue('CODIGOEMPRESA')};${form.getvalue('CODIGOESOCIALTRANSACAO')};EVENTO`;

			KTApp.blockPage();
			AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialXML', 'BuscarValorMasterAjax', $achave, '', (retorno) => {
				resolve(retorno.data.result);
			});
			KTApp.unblockPage();
		} else {
			resolve('');
		}
	});
}

function getNomeArquivo(evento, codigoempresa, codigotransacao, complemento) {
	return `${evento}_${formatMask(codigoempresa, 4)}_${formatMask(codigotransacao, 12)}_${complemento}`;
}

function formatMask(value, totalWidth, paddingChar) {
	var length = totalWidth - value.toString().length + 1;
	return Array(length).join(paddingChar || '0') + value;
};

function nActFormatarXMLExecute() {
	let prettifyXml = FormManager.getUtil('PrettifyXml');
	let form = FormManager.byname('TnFpaDMeSocialXML', '');
	let field = form.fieldbyName("XML");
	let xml = field.getvalue();
	let formatedXml = xml ? prettifyXml(xml) : xml;
	field.setvalue(formatedXml);
	field.componente.trigger('change')
}

function statusPermitido(listaStatus) {
	return new Promise((resolve, reject) => {
		let form = FormManager.byname('TnFpaDMeSocialXML', '');
	
		if (form.getvalue('CODIGOEMPRESA') && form.getvalue('CODIGOESOCIALTRANSACAO')) {    
			KTApp.blockPage();
			let $achave = `${form.getvalue('CODIGOEMPRESA')};${form.getvalue('CODIGOESOCIALTRANSACAO')};STATUS`;
			AJaxCadastroExecuteMethodGetProperty('TnFpaDMeSocialXML', 'BuscarValorMasterAjax', $achave, '', (retorno) => {
				resolve(listaStatus.includes(retorno.data.result));
				KTApp.unblockPage();
			});
		}
	});
}

$(".btn-navigation").remove();
$('#actDataSetNextExecuteTnFpaDMeSocialXML').remove();
$('#actDataSetPriorExecuteTnFpaDMeSocialXML').remove();