// #region AbrirEventosVariaveis
function nActAbrirCadastroEventosVar() {
	let formAtual = FormManager.byname(WizardManager.context.DetalheAtivo, '');
	let filtros = {};
	filtros['CODIGOEMPRESA'] = formAtual.getvalue('CODIGOEMPRESA');
	filtros['CODIGOPERCALCULO'] = formAtual.getvalue('CODIGOPERCALCULO');
	filtros['CODIGOFUNCCONTR'] = formAtual.getvalue('CODIGOFUNCCONTR');

	AbrirCadastro('TnFpaDMEventoVarPaiFunc', true, filtros);
	setTimeout(() => {
		criarDialogOk('Ao alterar os eventos variáveis, é necessário recalcular o rascunho.', 'Aviso');
	}, 100);
}
// #endregion

//#region
function nActMovimComplDissidio() {
	let formAtual = FormManager.byname(WizardManager.context.DetalheAtivo, '');
	let filtros = {};
	filtros['CODIGOEMPRESA'] = formAtual.getvalue('CODIGOEMPRESA');
	filtros['CODIGOFUNCCONTR'] = formAtual.getvalue('CODIGOFUNCCONTR');
	filtros['COMPLEMENTAR'] = formAtual.getvalue('COMPLEMENTAR');

	AbrirCadastro('TnFpaDMRescisaoMovim', true, filtros);
	setTimeout(() => {
		criarDialogOk('Realize manutenções dos eventos variáveis no Movimento da Rescisão, se necessário, e após realize o cálculo da Rescisão Complementar no Passo "Integrar Rascunho - Pgto".', 'Aviso');
	}, 100);
}
//#endregion

// #region NavegacaoConferenciasCalculo
function actContrato_Anterior() {
	getContrato('anterior');
}

function actProximo_Contrato() {
	getContrato('proximo');
}

function actPeriodo_Anterior() {
	getPeriodo('anterior');
}

function actProximo_Periodo() {
	getPeriodo('proximo');
}

function getContrato(origem) {
	if (podeNavegar) {
		let formAtual = FormManager.byname(WizardManager.context.DetalheAtivo, '');
		let params = JSON.stringify({
			'CODIGOEMPRESA': formAtual.getvalue('CODIGOEMPRESA'),
			'CODIGOPERCALCULO': formAtual.getvalue('CODIGOPERCALCULO'),
			'CODIGOFUNCCONTR': formAtual.getvalue('CODIGOFUNCCONTR'),
			'ORIGEM': origem
		});

		KTApp.blockPage();
		AJaxCadastroExecuteMethodGetProperty('TnFpaDMFuncContrato', 'DadosContratoAjax', params, '', (retorno) => {
			if (retorno.data.result.CODIGOFUNCCONTR) {
				if (formAtual.getvalue('CODIGOFUNCCONTR') != retorno.data.result.CODIGOFUNCCONTR) {
					formAtual.setvalue('CODIGOFUNCCONTR', retorno.data.result.CODIGOFUNCCONTR);
					formAtual.executeAction('ActionExecutarExecute');
				}
			}
		});
		KTApp.unblockPage();
	}
}

function getPeriodo(origem) {
	if (podeNavegar) {
		let formAtual = FormManager.byname(WizardManager.context.DetalheAtivo, '');

		KTApp.blockPage();
		request = new RequestDadosCadastro('TnFpaDMPeriodoCalculo', '');
		request.addFiltro('CODIGOEMPRESA', formAtual.getvalue('CODIGOEMPRESA'));
		request.addFiltro('CODIGOPERCALCULO', formAtual.getvalue('CODIGOPERCALCULO'));
		request.origem = origem;
		request.executar((retorno) => {
			if (retorno.data.CODIGOPERCALCULO) {
				if (formAtual.getvalue('CODIGOPERCALCULO') != retorno.data.CODIGOPERCALCULO) {
					formAtual.setvalue('CODIGOPERCALCULO', retorno.data.CODIGOPERCALCULO);
					formAtual.executeAction('ActionExecutarExecute');
				}
			}
		});
		KTApp.unblockPage();
	}
}

function podeNavegar() {
	const detalhes = ['TNFPADPCONFERENCIACALCDISSIDIO', 'TNFPADPCONFERENCIACALCEFETIVADODISSIDIO'];
	return detalhes.includes(WizardManager.context.DetalheAtivo);
}
// #endregion
