const statusAgendados = 0;
const statusProcessando = 1;
const statusVerificar = 2;
const statusConcluido = 3;
const statusTodos = 5;

FormManager.afterCreateAllForms.subscribe(function () {
    let formBusca = FormManager.byname('TNFPADPCONTROLETRANSMISSAOGUIAAUTOMATIZADA', '');
    
    if (formBusca) {
        formBusca.AfterModal = () => {
            formBusca.executeAction('ActionExecutarExecute');
        }
    }

    formBusca?.AfterExecuteActionProcess.subscribe(() => {
        let statusBusca = formBusca.getvalue('PSTATUS');

        AJaxProcessoExecuteMethodGetProperty({_AClass: 'TnFpaDPControleTransmissaoGuiaAutomatizada',
                                              _AMethodName: 'ContarCards',
                                              _AValues: JSON.stringify(formBusca.idrequest),
                                              _ANamePropertys: '',
                                              onSuccess: AtualizarCards});
        
        if ( statusBusca == statusAgendados ) {
            setActionEnabled({
                'ActReprocessarConsulta': true
            });
        } else if ( statusBusca == statusVerificar ) {
            setActionEnabled({
                'ActAgilizarEnvio': true
            });
        } else if ( statusBusca == statusConcluido ) {
            setActionEnabled({
                'ActAgilizarEnvio': true
            });
        } else {
            setActionEnabled({
                'ActAgilizarEnvio': true,
                'ActReprocessarConsulta': true
            });    
        }
    });
});

function AtualizarCards(json) {
    if (json.data.result) {
        widgetManager.get('Agendados').setValue({Valor: json.data.result.Agendados});
        widgetManager.get('Processando').setValue({Valor: json.data.result.Processando});
        widgetManager.get('Verificar').setValue({Valor: json.data.result.Verificar});
        widgetManager.get('Sucesso').setValue({Valor: json.data.result.Sucesso});
    }
}

function ActFiltroAgendados() {
    gridFilterStatus(statusAgendados);
}

function ActFiltroProcessando() {
    gridFilterStatus(statusProcessando);
}

function ActFiltroVerificar() {
    gridFilterStatus(statusVerificar);
}

function ActFiltroSucesso() {
    gridFilterStatus(statusConcluido);
}

function gridFilterStatus(status) {
    formBusca = FormManager.byname('TNFPADPCONTROLETRANSMISSAOGUIAAUTOMATIZADA', '');
    formBusca.setvalue('PSTATUS', status);
    formBusca.executeAction('ActionExecutarExecute');
}

function setActionEnabled(actionsConfig) {
    dataGridName = 'nClientDataSet';
    gridManager.setCustomConfig({
        gridName: dataGridName,
        config: {
            toolbarItems: {
                disabled: (toolbuttonConfig) => {
                    const name = toolbuttonConfig.Name;
                    return actionsConfig[name];
                },
            },
        }
    });

    const grid = gridManager.get(dataGridName);
    if (grid) grid.repaint();
}
