//#region mensagens dialogs
const msgReverter =
	'Você excluirá todas as informações do cálculo do período informado. <br>' +
	'Esse processo é irreversível. <br>' +
	'Deseja continuar?';

const msgRescisaoCompet =
	'Pode existir Funcionários com Rescisão na Competência ou em Competência Superior, ' +
	'a exclusão deste Período de Cálculo poderá gerar diferença de Valores. <br>' +
	'Deseja continuar?';
//#endregion

FormManager.afterCreateAllForms.subscribe(function () {
	$('#formFieldwidgets').hide();
});

function actReverterProcessoCloud() {
	let form = FormManager.byname('TnFpaDPCalculoAutomatizadoFolha', '');

	criarDialogSimNao(msgReverter, 'Confirmação', () => {
		criarDialogSimNao(msgRescisaoCompet, 'Confirmação', () => {
			if (form.getvalue('PCODIGOCONFIG') && form.getvalue('PCODIGOTIPOCALC') && form.getvalue('PDATAINICIAL')) {
				$achave = `${form.getvalue('PCODIGOCONFIG')};${form.getvalue('PCODIGOTIPOCALC')};${form.getvalue('PDATAINICIAL')}`;

				AJaxProcessoExecuteMethodGetProperty({
					_AClass: 'TnFpaDPCalculoAutomatizadoFolha',
					_AMethodName: 'ReverterProcessoCloud',
					_AValues: $achave,
					_ANamePropertys: '',
					onSuccess: (retorno) => {
						if (!retorno.data.result) {
							qNotifier.error('Não foi possível reverter o processo.');
						} else {
							AbrirProcessoModal({
								_AClasse: 'TnFpaDPExcluirPeriodoCalculoAutomatico',
								AParams: {
									PCODIGOTIPOCALC: retorno.data.result.CODIGOTIPOCALC,
									PCOMPETENCIA: retorno.data.result.COMPETENCIA,
									PCODIGOGRUPOPROC: retorno.data.result.CODIGOGRUPOPROC,
									PEMPRESAS: retorno.data.result.EMPRESAS,
									PINTEGRACAOCONTABIL: retorno.data.result.INTEGRACAOCONTABIL
								},
								Executar: true,
								form: FormManager.byname('TnFpaDPCalculoAutomatizadoFolha'),
							});

							$("#framemodal").on("load", function () {
								const contentWindow = this.contentWindow;
								if (!contentWindow.FormManager) return;
								contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal) => {
									let formDP = FormManagerModal.byname('TnFpaDPExcluirPeriodoCalculoAutomatico', '');
									formDP.setenabled('PCODIGOTIPOCALC', false);
									formDP.setenabled('PCOMPETENCIA', false);
									formDP.setenabled('PCODIGOGRUPOPROC', false);
									formDP.setenabled('PEMPRESAS', false);
									formDP.setenabled('PINTEGRACAOCONTABIL', false);
								})
							})
						}
					}
				});
			} else {
				qNotifier.error('Parâmetros inválidos. Verifique os parâmetros informados.');
			}
		});
	});
}
