FormManager.afterCreateAllForms.subscribe(function() {
	let form = FormManager.byname('TnFpaDPConferenciaCalcDissidio', '');

	if (WizardManager.context.Params) {
		form.changeState(FormState.cadAlterando);
	};

	setTimeout(() => {
		form.setvalue('CODIGOSINDDISSIDIO', WizardManager.context.Params.PCODIGOSINDDISSIDIO);
	}, 500);

	form.AfterExecuteActionProcess.subscribe(() => AtualizarTotalizadores());

	function AtualizarTotalizadores() {
		let codigoEmpresa = form.getvalue('CODIGOEMPRESA');
		let codigoPerCalculo = form.getvalue('CODIGOPERCALCULO');
		let codigoFuncContr = form.getvalue('CODIGOFUNCCONTR');

		if ((codigoEmpresa) && (codigoPerCalculo) && (codigoFuncContr)) {
			$achave = `${codigoEmpresa};${codigoPerCalculo};${codigoFuncContr}`;

			AJaxProcessoExecuteMethodGetProperty({
				_AClass: 'TnFpaDPConferenciaCalcDissidio',
				_AMethodName: 'GetValoresTotalizadoresCloudAjax',
				_AValues: $achave,
				_ANamePropertys: '',
				onSuccess: setarValoresTotais,
			});
		}
	}

	function setarValoresTotais(retorno) {
		if (retorno.data.result) {
			$('#widget__wdgBaseIRRFNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfNor;
			$('#widget__wdgBaseINSSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseInssNor;
			$('#widget__wdgBaseFGTSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseFgtsNor;
			$('#widget__wdgBaseIRRF13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfDec;
			$('#widget__wdgBaseINSS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseInssDec;
			$('#widget__wdgBaseFGTS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseFgtsDec;
			$('#widget__wdgBaseIRRFFerias')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfFer;
			$('#widget__wdgBaseIRRFLucro')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfLucro;
			$('#widget__wdgBaseIRRFDependentes')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ADependIR;
			$('#widget__wdgBaseINSSDependentes')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ADependIRVlr;	
			$('#widget__wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.AProventos;
			$('#widget__wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ADescontos;
			$('#widget__wdgLiquidos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ALiquido;
			$('#widget__wdgSalarioBase')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ASalBase;
		}
	}
});
