FormManager.afterCreateAllForms.subscribe(function() {
	let form = FormManager.byname('TnFpaDPConferenciaCalcEfetivadoDissidio', '');

	if (WizardManager.context.Params) {
		form.changeState(FormState.cadAlterando);
	};

	setTimeout(() => {
		form.setvalue('CODIGOSINDDISSIDIO', WizardManager.context.Params.PCODIGOSINDDISSIDIO);
		sugerirValores();
	}, 500);

	form.AfterExecuteActionProcess.subscribe(() => AtualizarTotalizadores());

	function AtualizarTotalizadores() {
		let codigoEmpresa = form.getvalue('CODIGOEMPRESA');
		let codigoPerCalculo = form.getvalue('CODIGOPERCALCULO');
		let codigoFuncContr = form.getvalue('CODIGOFUNCCONTR');

		if ((codigoEmpresa) && (codigoPerCalculo) && (codigoFuncContr)) {
			$achave = `${codigoEmpresa};${codigoPerCalculo};${codigoFuncContr}`;

			AJaxProcessoExecuteMethodGetProperty({
				_AClass: 'TnFpaDPConferenciaCalcDissidio',
				_AMethodName: 'GetValoresTotalizadoresCloudAjax',
				_AValues: $achave,
				_ANamePropertys: '',
				onSuccess: setarValoresTotais,
			});
		}
	}

	function setarValoresTotais(retorno) {
		if (retorno.data.result) {
			$('#widget_wdgBaseIRRFNormal_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfNor;
			$('#widget_wdgBaseINSSNormal_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseInssNor;
			$('#widget_wdgBaseFGTSNormal_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseFgtsNor;
			$('#widget_wdgBaseIRRF13_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfDec;
			$('#widget_wdgBaseINSS13_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseInssDec;
			$('#widget_wdgBaseFGTS13_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseFgtsDec;
			$('#widget_wdgBaseIRRFFerias_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfFer;
			$('#widget_wdgBaseIRRFLucro_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ABaseIrrfLucro;
			$('#widget_wdgBaseIRRFDependentes_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ADependIR;
			$('#widget_wdgBaseINSSDependentes_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ADependIRVlr;	
			$('#widget_wdgProventos_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.AProventos;
			$('#widget_wdgDescontos_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ADescontos;
			$('#widget_wdgLiquidos_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ALiquido;
			$('#widget_wdgSalarioBase_')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.ASalBase;
		}
	}

	function sugerirValores() {
		form.fields.forEach((field) => {
			if (WizardManager.context.Params.hasOwnProperty(field.nome)) {
				field.setvalue(WizardManager.context.Params[field.nome]);
			}
		});
	}
});
