﻿const statusAgendados = 0;
const statusProcessando = 1;
const statusVerificar = 2;
const statusConcluido = 3;
const statusTodos = 5;

FormManager.afterCreateAllForms.subscribe(function () {
  let formBusca = FormManager.byname('TNFPADPDOWNLOADXMLESOCIALCONTROLE', '');

  if (formBusca) {
    formBusca.AfterModal = () => {
        formBusca.executeAction('ActionExecutarExecute');
    }
}
  
  formBusca?.AfterExecuteActionProcess.subscribe(() => {
      let statusBusca = formBusca.getvalue('PSTATUS');

      AJaxProcessoExecuteMethodGetProperty({_AClass: 'TnFpaDPDownloadXMLeSocialControle',
                                            _AMethodName: 'ContarCards',
                                            _AValues: JSON.stringify(formBusca.idrequest),
                                            _ANamePropertys: '',
                                            onSuccess: AtualizarCards});
  });
});

function AtualizarCards(json) {
  if (json.data.result) {
      widgetManager.get('Agendados').setValue({Valor: json.data.result.Agendados});
      widgetManager.get('Processando').setValue({Valor: json.data.result.Processando});
      widgetManager.get('Verificar').setValue({Valor: json.data.result.Verificar});
      widgetManager.get('Sucesso').setValue({Valor: json.data.result.Sucesso});
  }
}

function ActFiltroAgendados() {
  gridFilterStatusXMLeSocialControle(statusAgendados);
}

function ActFiltroProcessando() {
  gridFilterStatusXMLeSocialControle(statusProcessando);
}

function ActFiltroVerificar() {
  gridFilterStatusXMLeSocialControle(statusVerificar);
}

function ActFiltroSucesso() {
  gridFilterStatusXMLeSocialControle(statusConcluido);
}

function gridFilterStatusXMLeSocialControle(status) {
  let formBusca = FormManager.byname('TNFPADPDOWNLOADXMLESOCIALCONTROLE', '');
  formBusca.setvalue('PSTATUS', status);
  formBusca.executeAction('ActionExecutarExecute');
}
