FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDPFichaFinancEvento', '');

	formAtual.AfterExecuteActionProcess.subscribe(() => AtualizarTotalizadores());

	function AtualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoPerCalculo = formAtual.getvalue('CODIGOPERCALCULO');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');

		if ((codigoEmpresa) && (codigoPerCalculo) && (codigoFuncContr)) {
			$achave = `${codigoEmpresa};${codigoPerCalculo};${codigoFuncContr}`;

			AJaxProcessoExecuteMethodGetProperty({
				_AClass: 'TnFpaDPFichaFinancEvento',
				_AMethodName: 'GetValoresTotalizadoresCloudAjax',
				_AValues: $achave,
				_ANamePropertys: '',
				onSuccess: setarValoresTotais,
			});
		}
	}

	function setarValoresTotais(retorno) {
		if (retorno.data.result) {
			$('#widget_wdgBaseIRRFNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseIrrfNor;
			$('#widget_wdgBaseINSSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseInssNor;
			$('#widget_wdgBaseFGTSNormal')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseFgtsNor;
			$('#widget_wdgBaseIRRF13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseIrrfDec;
			$('#widget_wdgBaseINSS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseInssDec;
			$('#widget_wdgBaseFGTS13')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseFgtsDec;
			$('#widget_wdgBaseIRRFFerias')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseIrrfFer;
			$('#widget_wdgBaseIRRFLucro')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.BaseIrrfLucro;
			$('#widget_wdgBaseIRRFDepend')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.DependIR;
			$('#widget_wdgBaseINSSDepend')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.DependIRVlr;
			$('#widget_wdgProventos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.Proventos;
			$('#widget_wdgDescontos')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.Descontos;
			$('#widget_wdgLiquido')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.Liquido;
			$('#widget_wdgSalarioBase')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.SalBase;
		}
	}
})

function actGerar_Evento_eSocial() {
	const mensagemConfirmacao = `
		Atenção!!!<br>
		Será gerado automaticamente evento de Inclusão/Retificação/Alteração, sem avaliar se existem transações anteriores processadas na área de trabalho eSocial!<br>
		Caso o evento já tenha sido processado pelo eSocial será rejeitado em duplicidade!<br>
		Eventos não periódicos anteriores a obrigatoriedade do eSocial não serão gerados!<br>
		Deseja enviar o Evento ao eSocial?`;

	criarDialogSimNao(mensagemConfirmacao, 'Confirmação', () => {
		let formAtual = FormManager.byname('TnFpaDPFichaFinancEvento', '');
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoPerCalculo = formAtual.getvalue('CODIGOPERCALCULO');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');

		if ((codigoEmpresa) && (codigoFuncContr)) {
			let params = JSON.stringify({
				'CODIGOEMPRESA': codigoEmpresa,
				'CODIGOPERCALCULO': codigoPerCalculo,
				'CODIGOFUNCCONTR': codigoFuncContr
			});

			KTApp.blockPage();
			AJaxProcessoExecuteMethodGetProperty({
				_AClass: 'TnFpaDPFichaFinancEvento',
				_AMethodName: 'GerarTransacaoeSocialAjax',
				_AValues: params,
				_ANamePropertys: '',
				onSuccess: function (retorno) {
					if (retorno.data.result.erro) {
						qNotifier.error(retorno.data.result.erro);
					}
				},
			});
			KTApp.unblockPage();
		}
	});
}

function actContrato_Anterior() {
	getContrato('anterior');
}

function actProximo_Contrato() {
	getContrato('proximo');
}

function actPeriodo_Anterior() {
	getPeriodo('anterior');
}

function actProximo_Periodo() {
	getPeriodo('proximo');
}

function getContrato(origem) {
	let formAtual = FormManager.byname('TnFpaDPFichaFinancEvento', '');
	let params = JSON.stringify({
		'CODIGOEMPRESA': formAtual.getvalue('CODIGOEMPRESA'),
		'CODIGOPERCALCULO': formAtual.getvalue('CODIGOPERCALCULO'),
		'CODIGOFUNCCONTR': formAtual.getvalue('CODIGOFUNCCONTR'),
		'ORIGEM': origem
	});

	KTApp.blockPage();
	AJaxCadastroExecuteMethodGetProperty('TnFpaDMFuncContrato', 'DadosContratoAjax', params, '', (retorno) => {
		if (retorno.data.result.CODIGOFUNCCONTR) {
			formAtual.setvalue('CODIGOFUNCCONTR', retorno.data.result.CODIGOFUNCCONTR);
			formAtual.executeAction('ActionExecutarExecute');
		}
	});
	KTApp.unblockPage();
}

function getPeriodo(origem) {
	let formAtual = FormManager.byname('TnFpaDPFichaFinancEvento', '');

	KTApp.blockPage();
	request = new RequestDadosCadastro('TnFpaDMPeriodoCalculo', '');
	request.addFiltro('CODIGOEMPRESA', formAtual.getvalue('CODIGOEMPRESA'));
	request.addFiltro('CODIGOPERCALCULO', formAtual.getvalue('CODIGOPERCALCULO'));
	request.origem = origem;
	request.executar((retorno) => {
		if (retorno.data.CODIGOPERCALCULO) {
			formAtual.setvalue('CODIGOPERCALCULO', retorno.data.CODIGOPERCALCULO);
			formAtual.executeAction('ActionExecutarExecute');
		}
	});
	KTApp.unblockPage();
}
