FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDPLimparDebitoGPS', '');
    $("input[name^='p.PLIMPAR']").change(DoChangeLimpar);
    $("input[name^='p.PTIPOGPS1']").change(DoChangeTipoGPS);

    DisabledTipoGPS();

    function DisabledTipoGPS() {
        $("input[name^='p.PLIMPAR']").each((index, el) => {
            DoChangeLimparEl(el);
        });
    }

    function DoChangeTipoGPS(e) {
        const AElement = e.currentTarget;
        const folhaComplementar = AElement.name.indexOf('p.PTIPOGPS1_checkbox_10') > -1;
        const reclamatoriaTrabalhista = AElement.name.indexOf('p.PTIPOGPS1_checkbox_9') > -1;
        if (folhaComplementar || reclamatoriaTrabalhista) {
            const AEnabledPeriodoCalculo = isFolhaComplementar() || isReclamatoriaTrabalhista();
            form.setenabledrequired('PCODIGOPERCALCULO', AEnabledPeriodoCalculo);
            if (!AEnabledPeriodoCalculo) {
                form.setvalue('PCODIGOPERCALCULO', '');
            }    
        }    
    }

    function DoChangeLimpar(e) {
        const AElement = e.currentTarget;
        DoChangeLimparEl(AElement);
    }

    function DoChangeLimparEl(el) {
        const AChecked = $(el).prop('checked');
        if (AChecked) {
            enabledTipoGPS(el.name);
        } else {
            desmarcarTipoGPS(el.name);        
        }
    }

    function desmarcarTipoGPS(elementName) {
        if (isEmpresa(elementName)) {
            getCheckboxesEmpresa().prop('checked', false).attr('disabled', 'disabled');
        } else if (isFuncionario(elementName)) {
            getCheckboxesFuncionario().prop('checked', false).attr('disabled', 'disabled');
        } else {
            getCheckboxesTerceiro().prop('checked', false).attr('disabled', 'disabled');
        }
    }

    function enabledTipoGPS(elementName) {
        if (isEmpresa(elementName)) {
            getCheckboxesEmpresa().removeAttr('disabled');
        } else if (isFuncionario(elementName)) {
            getCheckboxesFuncionario().removeAttr('disabled');
        } else {
            getCheckboxesTerceiro().removeAttr('disabled');
        }
    }
    
    function isFolhaComplementar() {
        return form.getvalue('PTIPOGPS1_checkbox_10');
    }

    function isReclamatoriaTrabalhista() {
        return form.getvalue('PTIPOGPS1_checkbox_9');
    }

    function getCheckboxesEmpresa() {
        return $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[1-4|9]/); });
    }

    function getCheckboxesFuncionario() {
        return $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[5|6]/); });
    }

    function getCheckboxesTerceiro() {
        return $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[7|8]/); }); 
    }

    function isEmpresa(elementName) {
        return elementName.indexOf('checkbox_1') > -1;
    }

    function isFuncionario(elementName) {
        return elementName.indexOf('checkbox_2') > -1;
    }
});

