FormManager.afterCreateAllForms.subscribe(function () {
	let form = FormManager.byname('TNFPADPESOCIALGERAREVENTOSABERTURAFECHAMENTO', '');

    if (form != null) {
        AposCarregarArvore();
    };

    form.getcomponent('pTipoEvento').change(conferirHabilitarPeriodicos);

    function conferirHabilitarPeriodicos(){
        let opcoesAbertura = ["j1_8"];
        let opcoesFechamento = ["j1_1", "j1_2", "j1_3", "j1_4", "j1_5", "j1_6", "j1_7", "j1_11", "j1_14"];
        let classe = "#checktreeviewPEVENTOINICIALPERIODICO";

        if (form.fieldbyName('pTipoEvento').getvalue() == 1) {
            opcoesAbertura.forEach(opcao => DesabilitarCheckboxes(classe, opcao, true));
            opcoesFechamento.forEach(opcao => DesabilitarCheckboxes(classe, opcao, false));
        } else {
            opcoesAbertura.forEach(opcao => DesabilitarCheckboxes(classe, opcao, false));
            opcoesFechamento.forEach(opcao => DesabilitarCheckboxes(classe, opcao, true));
        }
    };

    function AposCarregarArvore(){
        $('#checktreeviewPEVENTOINICIALPERIODICO').bind("loaded.jstree", function (event, data) {
            conferirHabilitarPeriodicos();
        });
    };

    function DesabilitarCheckboxes(classe, opcao, ativar = false){
        const tree = $(classe).jstree(true);
        if (ativar) {
            tree.enable_node(opcao);
        } else {
            tree.disable_node(opcao);
            tree.uncheck_node(opcao);
        };
    };
});