FormManager.afterCreateAllForms.subscribe(function () {
	let form = FormManager.byname('TnFpaDPeSocialGerarEventosCargaInicial', '');

    if (form != null) {
        AposCarregarArvore();
        form.setrequired('PEVENTOINICIALSST', false);
        form.setrequired('PCOMPET', true);
    };

    form.getcomponent('PCODIGOFUNCCONTR').blur(conferirHabilitarPeriodicos);
    form.getcomponent('PCODIGOTERC').blur(conferirHabilitarPeriodicos);

    function conferirHabilitarPeriodicos(){
        let opcoes = ["j1_5", "j1_6", "j1_7", "j1_8", "j1_11", "j1_14", "j1_17", "j1_20"];
        let classe = "#checktreeviewPEVENTOINICIALPERIODICO";        
        let habilita = !(form.getvalue('PCODIGOFUNCCONTR')) && !(form.getvalue('PCODIGOTERC'));

        opcoes.forEach((opcao) => DesabilitarCheckboxes(classe, opcao, habilita));
    };

    function conferirHabilitarNaoPeriodico(){
        let opcoes = ["j2_1", "j2_3", "j2_3", "j2_4", "j2_5", "j2_6", "j2_7", "j2_8", "j2_9", "j2_11", "j2_12"];
        let classe = "#checktreeviewPEVENTOINICIALNAOPERIODICO";
            
        opcoes.forEach((opcao) => DesabilitarCheckboxes(classe, opcao));
    };

    function AposCarregarArvore(){
        $('#checktreeviewPEVENTOINICIALPERIODICO').bind("loaded.jstree", () => conferirHabilitarPeriodicos());
        $('#checktreeviewPEVENTOINICIALNAOPERIODICO').bind("loaded.jstree", () => conferirHabilitarNaoPeriodico());
    };

    function DesabilitarCheckboxes(classe, opcao, ativar = false){
        const tree = $(classe).jstree(true);
        if (ativar) {
            tree.enable_node(opcao);
        } else {
            tree.disable_node(opcao);
            tree.uncheck_node(opcao);
        };
    };
});