FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnGemDMCertificadoOutorga', '');
    form.getcomponent('CERTIFDIGITAL').blur(DoChangeCertifDigital);

    function decodeHTMLEntities(text) {
        var textArea = document.createElement('textarea');
        textArea.innerHTML = text;
        return textArea.value;
    }

    function DoChangeCertifDigital() {
        KTApp.blockPage();

        if (([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) && (form.getvalue('CERTIFDIGITAL'))) {
            form.getvalueLookup('CERTIFDIGITAL', 'NOME').done((nome) => {
                form.setvalue('NOMEOUTORGADO', decodeHTMLEntities(nome));
            });

            form.getvalueLookup('CERTIFDIGITAL', 'TIPOINSCR').done((tipoInscr) => {
                form.setvalue('TIPOINSCR', tipoInscr);
            });

            form.getvalueLookup('CERTIFDIGITAL', 'INSCRFEDERAL').done((inscrFederal) => {
                form.setvalue('INSCRFEDERAL', inscrFederal);
            });

            form.getvalueLookup('CERTIFDIGITAL', 'CERTIFDIGITALVENC').done((dataVencimento) => {
                dataVencimento = moment(dataVencimento, 'MM-DD-YYYY').format('DD/MM/YYYY')
                form.setvalue('CERTIFDIGITALVENC', dataVencimento);
            });
        }
        KTApp.unblockPage();
    }    
});
