{
	var dataHist;
	var codSocio;
	function validateDataHistorico() {
		const form = FormManager.byname('TnGemDMcfgEmpresaGem', 'empresagem');
		if (form.estado === FormState.cadInsert) {
			
			let dataHistorico = form.fieldbyName('DATAHISTORICO');
			dataHistorico.setvalue(dataHistorico.getvalue());

			return askDate(form);
		}
		else if (form.estado === FormState.cadAlterando) {
			const mapFields = ({
				SOCIORESPCNPJ
			}) => ({
				SOCIORESPCNPJ
			});
			const convertNullToEmptyString = (obj) => Object.entries(obj).reduce((newObj, [key, value]) => ({ ...newObj, [key]: value || '' }), {});
			const getLastData = (data) => {
				return !data.datadetalhes 
					? data
					: data.datadetalhes.find(({ _AAlias, Class}) => (Class === 'TnGemDMCfgEmpresaGem' && _AAlias === 'empresagem'));
			};  

     		const previousData = getLastData(FormManager.ultimosDadosCadastro);
			const currentData = form.getValues();
			const hasChanges = !_.isEqual(mapFields(previousData), convertNullToEmptyString(mapFields(currentData)));
	
			if (hasChanges) {				
				return askDate(form);
			}
		}
	
		return Promise.resolve();
	}

	function askDate(form) {
		return new Promise((resolve, reject) => {
			const dialog = bootbox.dialog({
				title: 'Gravar Histórico Informações Alteradas',
				message: `<label  class="col-form-label">
							<span data-text>Data Histórico</span>		
							<span data-span-required>*</span>
						</label>
						<div class="input-group">
							<div class="input-group">
								<div class="input-group-prepend">
									<span class="input-group-text btn btn-icon  input-group-text">
										<i class="far fa-calendar-alt"></i>
									</span>
								</div>
								<input autocomplete="off" type="text" data-mask="00/00/0000" class="form-control kt-input datepicker" required>
							</div>
							<input type="hidden" id="DATAHISTORICO_modal"/>
						</div>`,
				buttons: {
					ok: {
						label: "Confirmar",
						className: 'btn-secondary text-white',
						callback: function(){
							var value =  $('#DATAHISTORICO_modal').val();
							dataHist = value;
							codSocio = form.getvalue('SOCIORESPCNPJ');
							var field = form.fieldbyName('DATAHISTORICO');

							if (value) {
								field.setvalue(value);
								resolve();
							}
							else {
								FormatErrorMessage('Data inválida, informe novamente');
								reject();
							}	
						}
					}
				}
			});
	
			dialog.init(function() {
				let input = $('.bootbox input.datepicker');

				$.applyDataMask(input);

				configureDatepicker($('.bootbox .datepicker'));
			});
		});
	}

	FormManager.afterCreateAllForms.subscribe(function () {			
		
		FormCfgEmpresaGem = FormManager.byname('TnGemDMcfgEmpresaGem', 'empresagem');
		FormCfgEmpresaGem.BeforePost = validateDataHistorico;
		FormCfgEmpresaGem.AfterPost = InserirSecundarios;
	
	   function InserirSecundarios() {
		codSocio =  parseInt(codSocio);	

		if (!isNaN(codSocio)) {
		let formCadEmpresa = FormManager.byname('TnGemDMEmpresa');
				
		let params = JSON.stringify({
			'pCodigoEmpresa': formCadEmpresa.getvalue('CODIGOEMPRESA'),
			'pCodigoSocio': codSocio,
			'pDataHistorico':dataHist,
		});
	   console.debug('2');
	   AJaxCadastroExecuteMethodGetProperty(
		'TnGemDMCfgEmpresaGem',
		'InserirDataHistoricoSocio',
		params,
		'',
		(retorno) => { 
			if (retorno.data.result.erros != '') {
				console.log(`Problemas ao cadastrar os dados secundários!\n${retorno.data.result.erros}`);
			} 
		}
	);
  }
}   
	}); 
}