FormManager.afterCreateAllForms.subscribe(function () {
    let formAtual = FormManager.byname('TnGemDMCotacao', '');

    var Executor = new nExpressionExecutor();

    requestConfigField();

    formAtual.getcomponent('CODIGOMOEDA').on('blur', requestConfigField);

    async function requestConfigField() {
        var tipoData = Executor.execute(`EXTERNO("PEGARTIPODATACOTACAOMOEDA", [${formAtual.getvalue("CODIGOMOEDA") || '""'}])`);
        var decimalCount = Executor.execute(`EXTERNO("PEGARCASASDECIMAISMOEDA", [${formAtual.getvalue("CODIGOMOEDA") || '""'}])`);

        changeDateByValue(await tipoData)

        let mask = '#.##0,';
        let newMask = mask.padEnd(mask.length + (await decimalCount), '0');

        changeDataMask('VALORCOTACAO', newMask);
        changeDataMask('VALORCOTACAOVENDA', newMask);
        KTApp.unblockPage();
    }

    function changeDateByValue(TipoData) {

        if (TipoData == 1) {
            changeDatePickerOptions('DATACOTACAO', {
                format: 'dd/mm/yyyy',
                minViewMode: 'days',
                displayLabelField: 'Data',
                dataMaskFormField: '00/00/0000'
            })
        }

        if (TipoData == 2) {
            changeDatePickerOptions('DATACOTACAO', {
                format: 'yyyy',
                minViewMode: 'years',
                displayLabelField: 'Ano',
                dataMaskFormField: '0000'
            })
        }

        if (TipoData == 3) {
            changeDatePickerOptions('DATACOTACAO', {
                format: 'mm/yyyy',
                minViewMode: 'months',
                displayLabelField: 'Mês/Ano',
                dataMaskFormField: '00/0000'
            })
        }
    }
})

function changeDatePickerOptions(fieldName, options) {
    let form = FormManager.byname('TnGemDMCotacao');
    let field = form.fieldbyName(fieldName);
    let datepicker = field.getDatepickerElement();
    let value = field.getvalue();

    if (datepicker) {
        let ismultidate = datepicker.hasClass('multidate');
        var isMonthYear = jqueryElement => jqueryElement.data("dicionario") == "DICDATAMESANO";

        let config = {
            autoclose: true,
            todayHighlight: true,
            language: "pt-BR",
            zIndexOffset: 100,
            autoclose: !ismultidate,
            showOnFocus: false,
            multidate: ismultidate,
            format: isMonthYear(datepicker) ? "mm/yyyy" : "dd/mm/yyyy",
            minViewMode: isMonthYear(datepicker) ? 1 : 0,
            ...options
        }

        datepicker.unmask();
        datepicker[0].dataset['mask'] = options.dataMaskFormField;
        $.applyDataMask(datepicker);

        datepicker.datepicker('remove');
        datepicker.datepicker(config);

        field.setvalue(value);
        field.setlabel(config.displayLabelField);
    }
}

function changeDataMask(fieldName, mask) {
    let form = FormManager.byname('TnGemDMCotacao');
    let field = form.fieldbyName(fieldName);

    field.componente.unmask();
    field.componente[0].dataset['mask'] = mask;
    $.applyDataMask(field.componente);
}
