let estaFechandoBigData = false;
{
	function validateDataHistorico() {
		const form = this;

		if (form.estado === FormState.cadInset) {
			let dataHistorico = form.fieldbyName('DATAHISTORICO');
			let dataInicial = form.fieldbyName('DATAINICIAL');
	
			dataHistorico.setvalue(dataInicial.getvalue());
		}
		else if (form.estado === FormState.cadAlterando) {
			const mapFields = ({
				NOMEESTABCOMPLETO,
				NOMEFANTASIA,
				TIPOINSCR,
				INSCRFEDERAL,
				CODIGOTIPOLOGRAD,
				ENDERECOESTAB,
				COMPLENDERESTAB,
				NUMENDERESTAB,
				BAIRROENDERESTAB,
				SIGLAESTADO,
				CODIGOMUNIC,
				CEPENDERESTAB,
				CODIGOATIVFEDERAL,
				DESCRATIVFEDESTAB,
				NUMEROREGIST,
				INSCRESTAD,
				CODIGOATIVESTAD,
				DESCRATIVESTESTAB,
				CODIGOATIVMUNIC,
				DESCRATIVMUNESTAB
			}) => ({
				NOMEESTABCOMPLETO,
				NOMEFANTASIA,
				TIPOINSCR,
				INSCRFEDERAL,
				CODIGOTIPOLOGRAD,
				ENDERECOESTAB,
				COMPLENDERESTAB,
				NUMENDERESTAB,
				BAIRROENDERESTAB,
				SIGLAESTADO,
				CODIGOMUNIC,
				CEPENDERESTAB,
				CODIGOATIVFEDERAL,
				DESCRATIVFEDESTAB,
				NUMEROREGIST,
				INSCRESTAD,
				CODIGOATIVESTAD,
				DESCRATIVESTESTAB,
				CODIGOATIVMUNIC,
				DESCRATIVMUNESTAB
			});
			const convertNullToEmptyString = (obj) => Object.entries(obj).reduce((newObj, [key, value]) => ({ ...newObj, [key]: value || '' }), {});
			const getLastData = (data) => {
				return !data.datadetalhes 
					? data
					: data.datadetalhes.find(({ _AAlias, Class}) => (Class === 'TnGemDMEstab' && _AAlias === 'Estab'));
			};  

     		const previousData = getLastData(FormManager.ultimosDadosCadastro);
			const currentData = form.getValues();
			const hasChanges = estaFechandoBigData || previousData == undefined || !_.isEqual(mapFields(previousData), convertNullToEmptyString(mapFields(currentData)));
	
			if (hasChanges) {				
				return askDate(form);
			}
			estaFechandoBigData = false;
		}
	
		return Promise.resolve();
	}

	function askDate(form) {
		return new Promise((resolve, reject) => {
			const dialog = bootbox.dialog({
				title: 'Gravar Histórico Informações Alteradas',
				message: `<label  class="col-form-label">
							<span data-text>Data Histórico</span>		
							<span data-span-required>*</span>
						</label>
						<div class="input-group">
							<div class="input-group">
								<div class="input-group-prepend">
									<span class="input-group-text btn btn-icon  input-group-text">
										<i class="far fa-calendar-alt"></i>
									</span>
								</div>
								<input autocomplete="off" type="text" data-mask="00/00/0000" class="form-control kt-input datepicker" required>
							</div>
							<input type="hidden" id="DATAHISTORICO_modal"/>
						</div>
						<label  class="col-form-label">
						 <span data-text>Atualizar dados no Questor Zen</span>		
						 <span data-span-required>*</span>
					   </label>
					   <div class="select-input">
					     <select onfocus="focusImputFunc({element: this})" class="form-control kt-input cad-control cad-logchange ctrlATUALIZASINC " id="ctrlATUALIZASINC" name="p.SOCIEDADECONTAPARTICIPACAO" title="Informe sim caso o estabelecimento seja uma Sociedade em Conta de Participação" value="" data-dicionario="DICSIMNAO" required="" data-classname="TnGemDMEstab" data-alias="Estab">
						 <option value="1">Sim</option>
						 <option value="0">Não</option>
					   </select>`,
				buttons: {
					ok: {
						label: "Confirmar",
						className: 'btn-secondary text-white',
						callback: function(){
							var value =  $('#DATAHISTORICO_modal').val();
							var field = form.fieldbyName('DATAHISTORICO');

							if (value) {
								field.setvalue(value);
								resolve();
							}
							else {
								FormatErrorMessage('Data inválida, informe novamente');
								reject();
							}

							 var value =  $('#ctrlATUALIZASINC').val();								 				
							 if (value == 1) {						

								let filter = {
									'CodigoEmpresa': form.getvalue('CODIGOEMPRESA'),
									'CodigoEstab': form.getvalue('CODIGOESTAB')
								};

								ActExecuteProcesso({
									_AClass: 'TnGemDPSincronizarCadastros',
									_AParams: filter,									
								});
							 };		
						}
					}
				}
			});
	
			dialog.init(function() {
				let input = $('.bootbox input.datepicker');

				$.applyDataMask(input);

				configureDatepicker($('.bootbox .datepicker'));
			});
		});
	}

	FormManager.afterCreateAllForms.subscribe(function () {	
		let FormEstab = FormManager.byname('TnGemDMEstab', 'Estab');
		let FieldEstab = FormEstab.fieldbyName('NOMEESTAB');
		let FieldEstabCompleto = FormEstab.fieldbyName('NOMEESTABCOMPLETO');	
		let FieldDESCRATIVFEDESTAB = FormEstab.fieldbyName('DESCRATIVFEDESTAB');
		let FieldCODIGOATIVFEDERAL = FormEstab.fieldbyName('CODIGOATIVFEDERAL');
		let NomeEstabOld = FieldEstab.getvalue();
		
		FieldEstab.componente.on('focus', function(){ChangeNomeEstab(FormEstab)});
		FieldEstabCompleto.componente.on('focus', function(){ChangeNomeEstabCompleto(FormEstab, NomeEstabOld)});
		FieldDESCRATIVFEDESTAB.componente.on('focus', function(){setTimeout(ChangeFieldDESCRATIVFEDESTAB(FormEstab), 250)});
		FieldCODIGOATIVFEDERAL.componente.on('blur', function(){setTimeout(ChangeFieldDESCRATIVFEDESTAB(FormEstab), 250)});					
		
		FormEstab.BeforePost = validateDataHistorico;
		FormEstab.AfterPost = InserirSecundarios;

		$('#detalheModal').on('hide.bs.modal', function(e) {			
			if (e.target.outerHTML.indexOf('TnGemDPAtualizaEstabBigData') > 0) {
				estaFechandoBigData = true;
				FormEstab.estado = FormState.cadAlterando;
				FormEstab.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
			}
		});

		function InserirSecundarios() {
			let formCadEstab = FormManager.byname('TnGemDMEstab');
			
			if (formCadEstab.configextra != undefined) {
				let formCadEmpresa = FormManager.byname('TnGemDMEmpresa');
						
				let params = JSON.stringify({
					'pCodigoEmpresa': formCadEmpresa.getvalue('CODIGOEMPRESA'),
					'pCodigoEstab': formCadEstab.getvalue('CODIGOESTAB'),
					'pDados': formCadEstab.configextra
				});

				AJaxProcessoExecuteMethodGetProperty({
					_AClass: 'TnGemDPAtualizaEstabBigData',
					_AMethodName: 'ExecutarInclusaoDadosReceitaSecundariosAjaxCloud',
					_AValues: params,
					_ANamePropertys: '',
					onSuccess: (retorno) => { 
						if (retorno.data.result.erros != '') {
							qNotifier.error(`Problemas ao cadastrar os dados secundários!\n${retorno.data.result.erros}`);
						} 
					}
				});
			}
        }
	});
}

function ChangeNomeEstab(formularioEstab) {
	let formEmpresa = FormManager.byname('TnGemDMEmpresa', '');	
	var NomeEstab = formularioEstab.getvalue('NOMEESTAB');
	var CodEmpresa = formEmpresa.getvalue('CODIGOEMPRESA');
	var NomeEmpresa = formEmpresa.getvalue('NOMEEMPRESA');
	
	if ((formularioEstab.estado == FormState.cadInsert) && (CodEmpresa != null) && (NomeEstab == ''))  {
		formularioEstab.fieldbyName('NOMEESTAB').setvalue(NomeEmpresa)
	}
}

function ChangeNomeEstabCompleto(formularioEstab, NomeEstabOld) {
	var NomeEstabCompleto = formularioEstab.getvalue('NOMEESTABCOMPLETO');	
	var NomeEstabAtual = formularioEstab.getvalue('NOMEESTAB');
	
	if ((NomeEstabCompleto != '') &&  (NomeEstabOld != NomeEstabAtual)) {
		formularioEstab.fieldbyName('NOMEESTABCOMPLETO').setvalue(NomeEstabAtual)
	}
}

function ChangeFieldDESCRATIVFEDESTAB(formularioEstab) {
	var ValueCODIGOATIVFEDERALRESULT = document.getElementById('ctrlCODIGOATIVFEDERALRESULTTEXT').innerText;	
	var ValueCODIGOATIVFEDERAL = formularioEstab.getvalue('CODIGOATIVFEDERAL');	
	var ValueDESCRATIVFEDESTAB = formularioEstab.getvalue('DESCRATIVFEDESTAB');
	
	if ((ValueDESCRATIVFEDESTAB != ValueCODIGOATIVFEDERALRESULT) && (ValueCODIGOATIVFEDERAL != '')) {
		formularioEstab.fieldbyName('DESCRATIVFEDESTAB').setvalue(ValueCODIGOATIVFEDERALRESULT)
	}
}
         
function nActBuscarDadosReceitaCloudExecute() {
	let form = FormManager.byname('TnGemDMEstab');
	let stateDS = '';
	
	if (form.estado === 'dsInsert') {
		stateDS = 'S';
	}

	let params = {
		'pCodigoEmpresa': form.getvalue('CODIGOEMPRESA'),
		'pCodigoEstab': form.getvalue('CODIGOESTAB'),
		'pInscrFederal': form.getvalue('INSCRFEDERAL'),
		'pTipoInscr': form.getvalue('TIPOINSCR')
	};
    
	if (stateDS === '') { 
		AbrirProcessoModal({ _AClasse: 'TnGemDPAtualizaEstabBigData', AParams: params, form: form});
	} else {
		ExecutarInclusaoDadosReceita();		
	}
}

function ExecutarInclusaoDadosReceita() {
	let formEmpresa = FormManager.byname('TnGemDMEstab');
	
    let params = JSON.stringify({
	    'pCodigoEmpresa': formEmpresa.getvalue('CODIGOEMPRESA'),
		'pCodigoEstab': formEmpresa.getvalue('CODIGOESTAB'),
		'pInscrFederal': formEmpresa.getvalue('INSCRFEDERAL'),
		'pTipoInscr': formEmpresa.getvalue('TIPOINSCR')
	});

	AJaxProcessoExecuteMethodGetProperty({
			_AClass: 'TnGemDPAtualizaEstabBigData',
			_AMethodName: 'ExecutarInclusaoDadosReceitaAjaxCloud',
			_AValues: params,
			_ANamePropertys: '',
			onSuccess: requestDataSucesso,
	});
}

function requestDataSucesso(retorno) {
	if (retorno.data.result.erros != '') {
		qNotifier.error(retorno.data.result.erros);
	} else {	
		let formCadEstab = FormManager.byname('TnGemDMEstab');		
		
	    formCadEstab.setvalue('NOMEESTAB', retorno.data.result.dados.NOME.substring(0,100));	
		formCadEstab.setvalue('CEPENDERESTAB', retorno.data.result.dados.CEP);
		formCadEstab.setvalue('CODIGOTIPOLOGRAD', retorno.data.result.dados.CODIGOTIPOLOGRAD);
		formCadEstab.setvalue('ENDERECOESTAB', retorno.data.result.dados.ENDERECO.substring(0,40));
		formCadEstab.setvalue('NUMENDERESTAB', retorno.data.result.dados.NUMEENDERECO);
		formCadEstab.setvalue('COMPLENDERESTAB', retorno.data.result.dados.COMPLEMENTO.substring(0,50));
		formCadEstab.setvalue('BAIRROENDERESTAB', retorno.data.result.dados.BAIRRO.substring(0,30));	
        formCadEstab.setvalue('NOMEESTABCOMPLETO', retorno.data.result.dados.NOME.substring(0,300));
        formCadEstab.setvalue('NOMEFANTASIA', retorno.data.result.dados.NOMEFANTASIA.substring(0,55));
        formCadEstab.setvalue('CODIGONATURJURID', retorno.data.result.dados.CODIGONATURJURIDICA);	

		if ((retorno.data.result.dados.CODIGOMUNIC > 0) && (retorno.data.result.dados.SIGLAESTADO != '')) {
		  formCadEstab.setvalue('SIGLAESTADO', retorno.data.result.dados.SIGLAESTADO);
		  formCadEstab.setvalue('CODIGOMUNIC', retorno.data.result.dados.CODIGOMUNIC);
		}

		if (retorno.data.result.dados.CODIGOATIVFEDERAL != '') {
			formCadEstab.setvalue('CODIGOATIVFEDERAL', retorno.data.result.dados.CODIGOATIVFEDERAL);
		}

		if (retorno.data.result.DATAINICIOATIV != '') {
			formCadEstab.setvalue('DATAINICIOATIV', retorno.data.result.dados.DATAINICIOATIV);
            formCadEstab.setvalue('DATAINICIAL', retorno.data.result.dados.DATAINICIOATIV);
            formCadEstab.setvalue('DATAREGIST', retorno.data.result.dados.DATAINICIOATIV);
		}
		
		formCadEstab.setvalue('TIPOREGIST', 5);
		formCadEstab.fieldbyName('TIPOREGIST').componente.trigger('change');
        formCadEstab.setvalue('CODIGOTABFERIADO', 1);
		formCadEstab.setvalue('DDDFONE', retorno.data.result.dados.DDD);
		formCadEstab.setvalue('NUMEROFONE', retorno.data.result.dados.TELEFONE);
		formCadEstab.setvalue('EMAIL', retorno.data.result.dados.EMAIL.substring(0,100));

        formCadEstab.configextra = retorno.data.result.dados;  
	}
}