FormManager.afterCreateAllForms.subscribe(function() {
    let formAtual = FormManager.byname('TnGemDMPessoa', '');    
	
    formAtual.getcomponent('TIPOINSCR').change(HabilitarDesabilitarCampos);
    formAtual.getcomponent('TIPOFORNECEDOR').change(HabilitarDesabilitarCampos);
    formAtual.getcomponent('PRODUTRURAL').change(HabilitarDesabilitarCampos);
})

function HabilitarDesabilitarCampos() {
    formAtual = FormManager.byname('TnGemDMPessoa', '');
    var tipoinscr = formAtual.getvalue('TIPOINSCR');

    formAtual.setenabled('INSCRESTAD', ((tipoinscr != 1) && (tipoinscr != 3)));
    formAtual.setenabled('ALIQSIMPLESNACIONAL', (formAtual.getvalue('TIPOFORNECEDOR') != 0));
    formAtual.setenabled('INSCRPROD', (formAtual.getvalue('PRODUTRURAL') != 0));;
    formAtual.setenabled('DATANASC', ((tipoinscr != 2) && (tipoinscr != 3) && (tipoinscr != 4)));

    let agropecuario = formAtual.getvalue('PRODUTRURAL');
    let abaTribProdRural = $("[data-id=tabTnGemDMPessoaTribProdRural]");
    let abaProdutorRural = $("[data-id=tabTnGemDMPessoaProdutorRural]");
    let abaAtiSecundaria = $("[data-id=tabTnGemDMPessoaAtividadeSecundaria]");

    if (agropecuario == 1) {
        abaTribProdRural.show();
        abaProdutorRural.show();
    } else {
        abaTribProdRural.hide();
        abaProdutorRural.hide();
    }

    if (tipoinscr == 1) {
        abaAtiSecundaria.hide();
    } else {
        abaAtiSecundaria.show();
    }
}

function nActDadosReceitaCloud() {
	let form = FormManager.byname('TnGemDMPessoa');
	let stateDS = '';
	
	if (form.estado === 'dsInsert') {
		stateDS = 'S';
	}

	let params = {
		'pCodigoPessoa': form.getvalue('CODIGOPESSOA'),
		'pInscrFederal': form.getvalue('INSCRFEDERAL'),
		'pSiglaEstado': form.getvalue('SIGLAESTADO'),
		'pInserindoDesktop': stateDS
	};
    
	if (stateDS === '') { 
      AbrirProcessoModal({ _AClasse: 'TnGemDPConsultaDadosReceita', AParams: params, form: form});
	} else {
	  ExecutarInclusaoDadosReceita();	
	}
}

function ExecutarInclusaoDadosReceita() {
	let formPessoa = FormManager.byname('TnGemDMPessoa', ''); 
    let params = JSON.stringify({
	    'pCodigoPessoa': formPessoa.getvalue('CODIGOPESSOA'),
		'pInscrFederal': formPessoa.getvalue('INSCRFEDERAL'),
		'pTipoInscr': formPessoa.getvalue('TIPOINSCR')
	});

	AJaxProcessoExecuteMethodGetProperty({
			_AClass: 'TnGemDPConsultaDadosReceita',
			_AMethodName: 'ExecutarInclusaoDadosReceitaAjaxCloud',
			_AValues: params,
			_ANamePropertys: '',
			onSuccess: requestDataSucesso,
	});
}

function requestDataSucesso(retorno) {
	if (retorno.data.result.erros != '') {
		qNotifier.error(retorno.data.result.erros);
	} else {	
		let formCadPessoa = FormManager.byname('TnGemDMPessoa', '');
		var tipoinscr = formCadPessoa.getvalue('TIPOINSCR');
		var tipoForne = retorno.data.result.dados.OPCAOSIMPLES.Trim;	
		
		formCadPessoa.setvalue('NOMEPESSOA', retorno.data.result.dados.NOME.substring(0,50));	
		formCadPessoa.setvalue('CEPENDERPESSOA', retorno.data.result.dados.CEP);
		formCadPessoa.setvalue('LOGRADPESSOA', retorno.data.result.dados.LOGRADOURO.substring(0, 15));
		formCadPessoa.setvalue('ENDERECOPESSOA', retorno.data.result.dados.ENDERECO.substring(0,40));
		formCadPessoa.setvalue('NUMENDERPESSOA', retorno.data.result.dados.NUMEENDERECO);
		formCadPessoa.setvalue('COMPLENDERPESSOA', retorno.data.result.dados.COMPLEMENTO.substring(0,20));
		formCadPessoa.setvalue('BAIRROENDERPESSOA', retorno.data.result.dados.BAIRRO.substring(0,30));

		if ((retorno.data.result.dados.CODIGOMUNIC > 0) && (retorno.data.result.dados.SIGLAESTADO != '')) {
		  formCadPessoa.setvalue('SIGLAESTADO', retorno.data.result.dados.SIGLAESTADO);
		  formCadPessoa.setvalue('CODIGOMUNIC', retorno.data.result.dados.CODIGOMUNIC);
		}

		if (retorno.data.result.dados.CODIGOATIVFEDERAL != '') {
			formCadPessoa.setvalue('CODIGOATIVFEDERAL', retorno.data.result.dados.CODIGOATIVFEDERAL);
		}

		if (retorno.data.result.DATAINICIOATIV != '') {
			formCadPessoa.setvalue('DATANASC', retorno.data.result.dados.DATAINICIOATIV);
		}
		
		formCadPessoa.setvalue('DDDFONE', retorno.data.result.dados.DDD);
		formCadPessoa.setvalue('NUMEROFONE', retorno.data.result.dados.TELEFONE);
		formCadPessoa.setvalue('EMAIL', retorno.data.result.dados.EMAIL.substring(0,100));
		formCadPessoa.setvalue('DATAHORALCTO', Date.now());
		
		if ((tipoinscr != 2) && (tipoinscr != 3) && (tipoinscr != 4)) {
			formCadPessoa.setvalue('CONTRIBUINTE', 0);
		} else {
			formCadPessoa.setvalue('CONTRIBUINTE', 1);
		}
		
		if ((tipoForne === 5) || (tipoForne === 7)) {
			if (retorno.data.result.dados.PORTEEMPRESA === '01') {
				formCadPessoa.setvalue('TIPOFORNECEDOR', 2);		 
			} else {
				formCadPessoa.setvalue('TIPOFORNECEDOR', 1);
			}
		} else {
			formCadPessoa.setvalue('TIPOFORNECEDOR', 0);
		}
	}
}