FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnGemDMTabelaFeriado', '');

    form.getcomponent('ANOATUAL').change(FiltrarGridDetalhe);

    FormManager.byname('TnGemDMFeriado', '').gridContentReady.subscribe(() => {
        FiltrarGridDetalhe();
    });

    function FiltrarGridDetalhe() {
        if (form.getvalue('ANOATUAL')) {
            let AnoAtual = form.getvalue('ANOATUAL');
            let AnoInicio = '01/01/' + AnoAtual;
            let AnoFim = '31/12/' + AnoAtual;
            let grid = dxDataGrid.getInstance('#dataGridConteudoTnGemDMFeriado');

            grid.filter([["DATAFERIADO", ">=", AnoInicio], "and", ["DATAFERIADO", "<=", AnoFim]]);
        }
    };

    form.AfterSave.subscribe(() => {
        let codTabFeriado = form.getvalue('CODIGOTABFERIADO');
        let detalhaFeriado = form.getvalue('DETALHAFERIADO');
        let anoAtual = form.getvalue('ANOATUAL');
        
        if (codTabFeriado && detalhaFeriado && anoAtual) {
            $AChave = `${codTabFeriado};${detalhaFeriado};${anoAtual}`;

            AJaxCadastroExecuteMethodGetProperty('TnGemDMTabelaFeriado', 'ConfereGerarFeriadosCloud', $AChave, '', (retorno) => {
                if (retorno.data.result) {
                    bootbox.dialog({
                        message: `Deseja incluir os feriados para o ano de ${anoAtual}?`,
                        title: '',
                        buttons: {
                            Nao: {
                                label: 'Não',
                                className: "btn-cancel",
                                callback: () => {}
                            },
                            Sim: {
                                label: 'Sim',
                                className: "btn-success",
                                callback: () => { 
                                    $AChave = `${codTabFeriado};${anoAtual}`;
                                    AJaxCadastroExecuteMethodGetProperty('TnGemDMTabelaFeriado', 'GerarFeriadosCloud', $AChave, '', (retorno) => {
                                        const grid = dxDataGrid.getInstance('#dataGridConteudoTnGemDMFeriado');
                                        if (grid) grid.refresh()
                                    })
                                }
                            }
                        }
                    });
                }
            });
        }
    });

    setTimeout(() => {
        FiltrarGridDetalhe();
    }, 3000);
});