FormManager.afterCreateAllForms.subscribe(function () {
	const setHandlerReportAfterAction = function () {
		$( document ).ajaxSuccess((event, xhr, settings) => {
			if (settings.url.match(/nHttpServicos\/ExecutarOperacaoDataset/)) {
				try {
					const data = JSON.parse(xhr.responseText).data;
	
					if (data.Erro) return;
	
					handleReport(settings);
				}
				catch (e) {
					console.error(e);
				}
			}
		});
	};
	
	const handleReport = function (ajaxSettings) {
		const params = getReportParams(ajaxSettings);
	
		if (!params) return;

		openReport(params);
	};
	
	const getReportParams = function (ajaxSettings) {
		const data = parseRequestDataString(ajaxSettings.data).p;
		const reportType = getReportType(data.Action);

		if (!reportType) return;

		const form = FormManager.byname('TnGemDPConsultaLGPD');
		const formValues = form.getValues();
	
		return {
			Class: "nGemRRLGPD",
			OSTEP_1: "-1",
			PCODIGOEMPRESA: `${SessionManager.selecao.CODIGOEMPRESA}`,
			PCPF: formValues.PCPF,
			PDATA: moment().format('YYYY-MM-DD'),
			PTIPO: reportType,
		}
	};
	
	const getReportType = function (action) {
		if (['nActAnonimizarRegistro', 'nActAnonimizacaoDados'].includes(action)) return '2';
		if (['nActExcluirDados', 'nActExcluirRegistro'].includes(action)) return '4';
		if (['nActPortabilidade'].includes(action)) return '5';
	};
	
	const parseRequestDataString = function (data) {
		try {
			return JSON.parse(data.replace(/p=/, '"p":'));
		}
		catch {
			return {};
		}
	};

	const form = FormManager.byname('TnGemDPConsultaLGPD', '');
	
    form.afterCreateStaticFields.subscribe(function() {
		const isChangeEvent = true;

		form.getcomponent('PCPF').change(() => changeSituacaoCPF(form, isChangeEvent));
		
		resetParamRevogacao();
	});

	setHandlerReportAfterAction();
 
	setGridSelectionEvent(form);

	form.gridContentReady.subscribe((gridname) => {
		if (gridname != 'dataGridConteudocdsResultado') return;

		setTimeout(() => changeSituacaoCPF(form));
	});
});

function changeSituacaoCPF(form, isChangeEvent){
	let params = form.getValues();
	
	AJaxProcessoExecuteMethodGetProperty({
		_AClass: 'TnGemDPConsultaLGPD',
		_AMethodName: 'BuscarSituacaoBloqueioCloud',
		_AValues: JSON.stringify(params),
		_ANamePropertys: '',
		onSuccess: (res) => atualizarSituacao(res, isChangeEvent),
		blockPage: false,
	});
}

function atualizarSituacao(retorno, isChangeEvent){
	if (retorno.data.result.Erro) 
		qNotifier.error(retorno.data.result.Erro)
	else 
		AtualizarCaption(retorno.data.result.Situacao, isChangeEvent);
}	

function nActBloquearDesbloquearCloud(){
	let form = FormManager.byname('TnGemDPConsultaLGPD', '');
	let params = form.getValues();
	let situacaoAtual = "1";
	
	function bloquearDesbloquear(retorno){
		situacaoAtual = retorno.data.result.Situacao;

		if (situacaoAtual == "0") 
			executarBloqueioDesbloqueio()
		else  
			criarDialogSimNao('Ao bloquear os dados, eles ficarão apenas disponíveis para consulta, ficando as telas de cadastros bloqueadas para alterações ou quaisquer tratamentos de dados. <br>' +
                              'Ressalvadas as alterações via API de integração, banco de dados ou rotinas de importação. <br><br>' +
                              'Recomenda-se a anonimização ou exclusão após 3 meses de bloqueio.', 'Confirmação', 
							  executarBloqueioDesbloqueio);
	}

	function executarBloqueioDesbloqueio() {
		params["PSITUACAOCPF"] = situacaoAtual;
		
		AJaxProcessoExecuteMethodGetProperty({
			_AClass: 'TnGemDPConsultaLGPD',
			_AMethodName: 'BloquearDesbloquearCloud',
			_AValues: JSON.stringify(params),
			_ANamePropertys: '',
			onSuccess: FinalizarBloqueioDesbloqueio,
		});
	}

	AJaxProcessoExecuteMethodGetProperty({
		_AClass: 'TnGemDPConsultaLGPD',
		_AMethodName: 'BuscarSituacaoBloqueioCloud',
		_AValues: JSON.stringify(params),
		_ANamePropertys: '',
		onSuccess: bloquearDesbloquear,
	});
}

function FinalizarBloqueioDesbloqueio(retorno){
	let form = FormManager.byname('TnGemDPConsultaLGPD', '');
	
	if (retorno.data.result.Erro) {
		qNotifier.error(retorno.data.result.Erro);
		return;
	}
  
	if (retorno.data.result.Situacao == "0") 
	  ExibirRelatorioBloqueio();
  
	form.executeAction('ActionExecutarExecute');
}

function AtualizarCaption(ASituacao, isChangeEvent){
	gridManager.setCustomConfig({
		gridName: 'cdsResultado',
		config: {
			toolbarItems: {
				text: (toolbuttonConfig) => {
					if (toolbuttonConfig.Name != 'nActBloquearDesbloquearCloud') {
						return toolbuttonConfig.Caption;
					}

					return  ASituacao == '1' ? 'Bloquear dados' : 'Desbloquear Dados';
				},
				disabled: (toolbuttonConfig) => {
					return (ASituacao == '0') && [
						'nActAnonimizacaoDados',
						'nActExcluirDados',
						'nActPortabilidade',
						'nActRevogarConsentimento'
					].includes(toolbuttonConfig.Name);
				},
			},
		}
	});

	if (isChangeEvent) {
		const grid = gridManager.get('cdsResultado');

		if (grid) grid.repaint();
	}
}

function ExibirRelatorioBloqueio(){
	
	const getReportParams = function (formValues) {
		
		if (!formValues) return;
	
		return {
			Class: "nGemRRLGPD",
			OSTEP_1: "-1",
			PCODIGOEMPRESA: `${SessionManager.selecao.CODIGOEMPRESA}`,
			PCPF: formValues.PCPF,
			PDATA: moment().format('YYYY-MM-DD'),
		    PTIPO: 3,		
		}
	};	
	
	function ShowReportBloqueio() {
    	const form = FormManager.byname('TnGemDPConsultaLGPD');
		const params = getReportParams(form.getValues());
	
		if (!params) return;	
		
		openReport(params);
	};

	ShowReportBloqueio();
};

function nActRelatorioLogCloud(){
	let form = FormManager.byname('TnGemDPConsultaLGPD', '');
	let gridComponent = dxDataGrid.getInstance('#dataGridConteudocdsResultado');
	let data = gridComponent.getSelectedRowsData();
	let params = new Object();
	
	function EmitirRelatorio(retorno){
		const params = getReportParams(retorno);
		
		if (!params) return;

		openReport(params);
	} 

	const getReportParams = function (retorno) {
	
		if (!retorno.data.result.EncontrouDados) return;
		
		return {
			Class: "nGemRRLog",
			OSTEP_1: "-1",
			PDATAHORAINICIAL: '00:00:00',
			PDATAHORAFINAL: moment().format('YYYY-MM-DD HH:mm:ss'),
			POBJETO: retorno.data.result.Objeto,
			PCODIGOOPERACAO: '7;10',
			PCODIGOPARAM1: retorno.data.result.CodigoParam1,
		}
	};	

	if (data.length > 0) {
		params.tabela = data[0].NOMETABELA;
		params.parametros = form.getValues();
		
		AJaxProcessoExecuteMethodGetProperty({
			_AClass: 'TnGemDPConsultaLGPD',
			_AMethodName: 'BuscarParametrosRelatorioLog',
			_AValues: JSON.stringify(params),
			_ANamePropertys: '',
			onSuccess: (retorno) => {
				if (retorno.data.result.Erro) qNotifier.error(retorno.data.result.Erro);
				else EmitirRelatorio(retorno);

				resetParamRevogacao();
			},
		});
	}
	else {
		qNotifier.warning('Selecione um registro antes de executar esta ação');
	}
}

function openReport(params) {
	$.ajax({
		type: 'POST',
		url: "RelatorioImprimir",
		dataType: 'html',
		contentType: 'application/json;charset=UTF-8',
		data: JSON.stringify(params),
		error: handleReportError,
		success: function (data) {
			const el = $('<div style="display:none">');

			el.append(data);

			$(document.body).append(el).remove(el);
		}
	});
}

function handleReportError(response) {
	const htmlErrorPage = response.responseText;
	const startingIndices = [];

	if (verifyAjaxRedirect(response)) return;
	
	FormatErrorMessage('Erro inesperado');

	let indexOccurence = htmlErrorPage.indexOf('<script>', 0);

	while(indexOccurence >= 0) {
		startingIndices.push(indexOccurence);

		indexOccurence = htmlErrorPage.indexOf('<script>', indexOccurence + 1);
	}

	const scriptError = $(htmlErrorPage.substr(startingIndices.pop(), htmlErrorPage.length - '</html>'.length));

	$(document.body).append(scriptError).remove(scriptError);
}

function nActRevogarConsentimento() {
	const form = FormManager.byname('TnGemDPConsultaLGPD', '');
	const executeAction = (actionName) => {
		$(`button[data-action-name="${actionName}"]`).trigger('click');
	};

	const actionList = [
		{
			text: 'Excluir',
			actionName: 'nActExcluirDados',
		},
		{
			text: 'Bloquear',
			actionName: 'nActBloquearDesbloquearCloud',
		},
		{
			text: 'Anonimizar',
			actionName: 'nActAnonimizacaoDados',
		},
		{
			text: 'Portabilidade',
			actionName: 'nActPortabilidade',
		},
	];
	const actionListMap = actionList.reduce((obj, { actionName }, index) => ({ 
		...obj,
		[`${index}`]: actionName,
	}), {});

	bootbox.prompt({
		title: "Atenção!",
		message: '<p>A revogação de consentimento implica na finalização do vínculo.<br>Escolha uma ação a ser tomada sobre os dados:</p>',
		inputType: 'radio',
		inputOptions: actionList.map(({ text }, index) => ({ text, value: `${index}` })),
		buttons: {
			cancel: {
				label: 'Cancelar',
				className: 'btn-q-secondary',
			},
			confirm: {
				label: 'Confirmar',
				className: 'btn-q-primary',
			},
		},
		callback: function (result) {
			const actionName = actionListMap[result];

			if (actionName) form.setvalue('PREVOGACAOCONSENTIMENTO', '1');

			executeAction(actionName);
		}
	});
}


function nActPortabilidade(props) { runOperacaoDataset(props); }

function nActExcluirDados(props) { runOperacaoDataset(props); }

function nActAnonimizacaoDados(props) { runOperacaoDataset(props); }

function runOperacaoDataset(props) {
	const form = FormManager.byname('TnGemDPConsultaLGPD');
	const getProps = (originalProps, useOriginal) => {
		return useOriginal
			? originalProps
			: {
				...originalProps,
				_AOpcoes: {
					...originalProps._AOpcoes,
					DataSend: 'dsAll',
				},
			};
	};

	ActionExecutarOperacaoDataSet({
		...getProps(props, form.getvalue('PREVOGACAOCONSENTIMENTO') == '0'),
		ignoreGlobalAction: true,
	}).then(() => {
		resetParamRevogacao();
	});
}

function nActPortabilidadeCancelHandler() { resetParamRevogacao(); }

function nActExcluirDadosCancelHandler() { resetParamRevogacao(); }

function nActAnonimizacaoDadosCancelHandler() { resetParamRevogacao(); }

function resetParamRevogacao() {
	const form = FormManager.byname('TnGemDPConsultaLGPD');

	form.setvalue('PREVOGACAOCONSENTIMENTO', '0');
}

function setGridSelectionEvent(form) {
	form.afterCreateGridConteudoPreserveLast.subscribe((gridName) => {
		if (gridName !== 'dataGridConteudocdsResultado') return;

		const grid = dxDataGrid.getInstance(`#${gridName}`);
		const dataSource = grid.option('dataSource');
		const Type = {
			OBRIGATORIO: '1',
			NAOOBRIGATORIO: '0',
		};

		let selecting = false;

		grid.on('selectionChanged', (selectionEvent) => {
			if (selecting) return;

			selecting = true;

			const getDataForSelection = (gridDataSource, currentRowsData) => {
				const isSameContext = (gridRowData, currentRowData) => gridRowData['CODIGOCONTEXTO'] !== '0' && gridRowData['TIPO'] === Type.NAOOBRIGATORIO && currentRowData['TIPO'] === Type.NAOOBRIGATORIO && gridRowData['CODIGOCONTEXTO'] === currentRowData['CODIGOCONTEXTO'];

				return gridDataSource.filter((gridRowData) => {
					return currentRowsData.find((currentRowData) => isSameContext(gridRowData, currentRowData))
				});
			};

			if (selectionEvent.currentSelectedRowKeys.length) {
				selectionEvent.component
					.getDataByKeys(selectionEvent.currentSelectedRowKeys)
					.then((currentSelectedRowsData) => {
						const dataToSelect = getDataForSelection(dataSource, currentSelectedRowsData);

						if (dataToSelect.length > 1) {
							criarDialogOk(
								`O dado selecionado possui relacionamentos.<br>Em caso de execução das ações de anonimização ou exclusão, os dados relacionados também serão afetados.`,
								'Atenção!',
								function () {
									selectionEvent.component
										.selectRows([...selectionEvent.selectedRowsData, ...dataToSelect])
										.then(() => selecting = false);
								});
						}
						else {
							selecting = false;
						}
					});
			}

			if (selectionEvent.currentDeselectedRowKeys.length) {
				selectionEvent.component
					.getDataByKeys(selectionEvent.currentDeselectedRowKeys)
					.then((currentDeselectedRowsData) => {
						const dataToDeselect = getDataForSelection(dataSource, currentDeselectedRowsData);

						if (dataToDeselect.length > 1) {
							selectionEvent.component
								.deselectRows(dataToDeselect)
								.then(() => selecting = false)
						}
						else {
							selecting = false;
						}
					});
			}
		});
	});
}