const stAguardando = '0';
const stIntegrado  = '1';
const stIgnorado   = '2';
let integrationRowData = null;

FormManager.runAfterCreateAllForms(() => {
	widgetManager.get("wdgGrids").unsubscribeBroadCast();

	$("#framemodal").on("load", function() {
		const row = integrationRowData;
		integrationRowData = null;

		if (!row) return;

		const integrationData = getIntegrationData(row);
		this.contentWindow.FormManager.runAfterCreateAllForms(function(FormManagerModal, items) {
			let formModal = FormManagerModal.byname(row['DATAMODULE']);
			desabilitarActions(formModal);

			formModal.fields.forEach((field) => {
				if (integrationData.hasOwnProperty(field.nome)) {
					field.setvalue(integrationData[field.nome].trim());
				}
			});
			formModal.triggerExpressions();
		});
	});
});

function desabilitarActions(form) {
	form.setActionEnabled('actDataSetPriorExecute',   false);
	form.setActionEnabled('actDataSetNextExecute',    false);
	form.setActionEnabled('actDataSetInsertExecute',  false);
	form.setActionEnabled('actDataSetRefreshExecute', false);
}

function nActAbrirCadastro() {
	const grid = dxDataGrid.getInstance('#dataGridConteudocdsIntegracao');
	integrationRowData = grid.getSelectedRowsData()[0];
	const row = integrationRowData;

	if (!row) return;

	const Class = row['DATAMODULE'];

	AbrirCadastroModal({
		_AClasse: Class,
		AFiltros: FormManager.filterForCadGrid,
		ANovo: row['STATUS'] != stIntegrado,
		AClasseForm: 'TnGemDPIntegracaoCadastrosEdoc'
	});

	let formAtual = FormManager.byname('TnGemDPIntegracaoCadastrosEdoc');
	formAtual.AfterModal = null;

	const subscription = broadcastManager
		.subscription('save')
		.pipe(filter(({ data }) => (Class == (data?.Class || ''))))
		.subscribe((message) => {
			subscription.unsubscribe();
			if (message.type == 'save') {
				updateEdoc(row['DOCUMENTID'])
					.then((retorno) => {
						if (retorno === 'sucesso') {
							formAtual.AfterModal = () => {
								const dataSource = grid.getDataSource();
								updateDataSource(
									dataSource,
									dataSource.store().keyOf(row),
									{
										'DATA': JSON.stringify(message.data.data),
										'STATUS': stIntegrado
									}
								);
							}
						}
					});
			}
		});
}

function nActDescartar() {
	const grid = dxDataGrid.getInstance('#dataGridConteudocdsIntegracao');
	const dataSource = grid.getDataSource();
	const dataSourceStore = dataSource.store();

	Promise
		.all(grid.getSelectedRowsData().map((row) => {
			if (row['STATUS'] === stIntegrado) {
				cadastroExcluir(row);
			}

			updateEdoc(row['DOCUMENTID']);
			return dataSourceStore.update(
				dataSourceStore.keyOf(row),
				{
					'STATUS': stIgnorado
				}
			);
		}))
		.then(() => {
			dataSource.reload();
		});

	grid.deselectAll();
}

function getIntegrationData(row) {
	const integrationData = JSON.parse(row['DATA']);

	for (const key in integrationData) {
		if ((key.endsWith('_RESULTFIELD')) || (!integrationData[key])) {
			delete integrationData[key];
		} else if (String(integrationData[key]).includes('&nbsp')) {
			integrationData[key] = integrationData[key].replace(/&nbsp/g, " ").trim();
		}
	}

	return integrationData;
}

function updateEdoc(documentID) {
	return new Promise((resolve) => {
		resolve('sucesso');
		if (documentID) {
			AJaxProcessoExecuteMethodGetProperty({
				_AClass: 'TnGemDPIntegracaoCadastrosEdoc',
				_AMethodName: 'AtualizarEdocAjax',
				_AValues: documentID,
				_ANamePropertys: '',
				onSuccess: (retorno) => {
					resolve(JSON.parse(retorno.data.result)['msg']);
				},
			});
		} else {
			resolve('');
		}
	})
}

function updateDataSource(dataSource, key, data) {
	setTimeout(() => {
		dataSource
			.store()
			.update(key, data)
			.then(() => {
				dataSource
					.reload()
					.catch((e) => {
						console.error(e);
						FormatErrorMessage('Erro ao recarregar informações');
					});
			})
			.catch((e) => {
				console.error(e);
				FormatErrorMessage('Erro ao atualizar informações')
			});
	}, 300);
}

function cadastroExcluir(row) {
	if (!row) return;

	axios.post(
		'nHttpServicos/CadastroExcluir',
		{
			p: {
				...getIntegrationData(row),
				"Class": row['DATAMODULE'],
				"_AAlias": ""
			}
		}
	)
}

