FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCFG = FormManager.byname('TnPatDMPATCFGBEM', '');
	var FormularioBem = FormManager.byname('TnPatDMPATBEM', '');

	//Tipo de Depreciacao
	const DEPRECIACAONORMAL 			= 1;
	const DEPRECIACAOLINHARETA 			= 2;
	const DEPRECIACAOSALDOSDECRESCENTES = 3;
	const DEPRECIACAOUNIDADESPRODUZIDAS = 4;
	const DEPRECIACAOSALDOSCRESCENTES 	= 5;

	const SetarDATAINICIAL = function () {
		if (FormularioCFG.getvalue('DATAINICIAL') == '' && FormularioBem) {
			FormularioCFG.setvalue('DATAINICIAL', FormularioBem.getvalue('DATAAQUISICAO'));
		}
	}
	
	FormularioCFG.AfterSave.subscribe(function() {
		KTApp.blockPage();
			
		let params = JSON.stringify({
			'CODIGOBEM': FormularioBem.getvalue('CODIGOBEM'),
			'DATAINICIAL': new Date(FormularioBem.getvalue('DATAAQUISICAO')).toLocaleDateString('pt-BR', {timeZone: 'UTC'})
		});
		
		AJaxCadastroExecuteMethodGetProperty('TnPatDMPATCFGBEM', 'RegerarEncargosJson', params, '', (retorno) => { });		
		KTApp.unblockPage();
	});

	function EnableCamposCFG() {
		var AEnabled = FormularioCFG.configextra.VerificarContabilizaItem;
		FormularioCFG.setenabledrequired('CONTACTBENCARGO', AEnabled);

		var tipodepreciacao = parseInt(FormularioCFG.getvalue('TIPODEPRECIACAO'));

		if (tipodepreciacao == DEPRECIACAONORMAL) {
			requestPercentualDepreciacao();
		}

		var AEhSocietario = ($.inArray(tipodepreciacao, [DEPRECIACAOLINHARETA, DEPRECIACAOSALDOSCRESCENTES, DEPRECIACAOSALDOSDECRESCENTES, DEPRECIACAOUNIDADESPRODUZIDAS]) != -1);
		FormularioCFG.setenabledrequired('VALORRESIDUAL', AEhSocietario);
		FormularioCFG.setenabledrequired('VALORSOCIETARIO', AEhSocietario);

		var FEnabledRequiredFields = tipodepreciacao == DEPRECIACAOUNIDADESPRODUZIDAS;
		FormularioCFG.setenabledrequired('UNIDADEMEDIDA', FEnabledRequiredFields);
		FormularioCFG.setenabledrequired('PRODUCAOMENSALUNIDADES', FEnabledRequiredFields);
		FormularioCFG.setenabledrequired('PRODUCAOTOTALUNIDADES', FEnabledRequiredFields);

		var FEnabledRequiredFields = tipodepreciacao == DEPRECIACAONORMAL;
		FormularioCFG.setenabledrequired('PERCENTUALENCARGO', FEnabledRequiredFields);

		var FEnabledRequiredFields = ($.inArray(tipodepreciacao, [DEPRECIACAOLINHARETA, DEPRECIACAOSALDOSCRESCENTES, DEPRECIACAOSALDOSDECRESCENTES]) != -1);
		FormularioCFG.setenabledrequired('VIDAUTIL', FEnabledRequiredFields);

		var FEnabledRequiredFields = ($.inArray(tipodepreciacao, [DEPRECIACAOLINHARETA, DEPRECIACAOSALDOSCRESCENTES, DEPRECIACAOSALDOSDECRESCENTES, DEPRECIACAOUNIDADESPRODUZIDAS]) != -1);
		FormularioCFG.setenabledrequired('TIPOCONFIGURACAO', FEnabledRequiredFields);

		var FEnabledRequiredFields = (FormularioCFG.getvalue('TIPOCONFIGURACAO') == '1') && AEhSocietario;
		FormularioCFG.setenabledrequired('VALORRESIDUAL', FEnabledRequiredFields);

		FormularioCFG.setenabled('DATAFINAL', false);
	}

	function requestPercentualDepreciacao() {
		if ((FormularioCFG.getvalue('PERCENTUALENCARGO') == '') && FormularioBem && (FormularioBem.getvalue('CODIGOBEM') != '')) {
			if (FormularioCFG.getvalue('CODIGOEMPRESA') == '') {
				$achave = SessionManager.selecao.CODIGOEMPRESA + ';' + FormularioBem.getvalue('CODIGOBEM') + ';0';
			} else if (FormularioCFG.getvalue('CODIGOCFGBEM') != '') {
				$achave = FormularioCFG.getvalue('CODIGOEMPRESA') + ';' + FormularioBem.getvalue('CODIGOBEM') + ';' + FormularioCFG.getvalue('CODIGOCFGBEM');
			} else {
				$achave = FormularioCFG.getvalue('CODIGOEMPRESA') + ';' + FormularioBem.getvalue('CODIGOBEM') + ';0';
			}
			AJaxCadastroExecuteMethodGetProperty('TnPatDMPATCFGBEM', 'GetPercentualEncargo', $achave, '', requestPercentualDepreciacaoSucessoAjax);					
		}		
	}

	function requestPercentualDepreciacaoSucessoAjax(retorno) {
		FormularioCFG.setvalue('PERCENTUALENCARGO', retorno.data.result);
	}

	FormularioCFG.getcomponent('CODIGOBEM').change(EnableCamposCFG);
	FormularioCFG.getcomponent('TIPODEPRECIACAO').change(EnableCamposCFG);
	FormularioCFG.getcomponent('DATAINICIAL').focus(SetarDATAINICIAL);

	EnableCamposCFG();
});