FormManager.afterCreateAllForms.subscribe(function () {
	let formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');

	//Tipo de DACON
	DACONNAOUTILIZA = 1;
	DACON12MESES = 2;
	DACON24MESES = 3;
	DACON48MESES = 4;
	DACONINTEGRAL = 5;
	DACONDEPRECIACAO = 6;
	DACONAMORTIZACAO = 7;
	DACON6MESES = 8;
	DACONMPS = 9;

	if (formDacon.getcomponent('CODIGOBEM') != null) {
		formDacon.getcomponent('CODIGOBEM').change(EnableCamposDacon);
	}
	formDacon.getcomponent('TIPODACONCREDITO').change(EnableCamposDacon);
	formDacon.getcomponent('DATAINICIAL').focus(SetarDATAINICIAL);
	formDacon.getcomponent('DATAFINAL').focus(requestTipoConfig);
	formDacon.getcomponent('BASECALCULO').focus(SetarBASECALCULO);

	EnableCamposDacon();

	$("#framemodal").on("load", function() {
		const contentWindow = this.contentWindow;

		if (!contentWindow.FormManager) return;

		contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal, items) => {
			const form = FormManagerModal.byname('TnPatDPPatRecalcularCreditoDacon', '');

			if (form) { 
				setTimeout(function() { 
					form.setvalue('PCODIGOBEM', formDacon.getvalue('CODIGOBEM'));
					form.setvisible('PCODIGOBEM', false);
				}, 100);
			}
		});
	});
})

function SetarTIPOS() {
	formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');

	if (formDacon.getvalue('TIPOAPURACAO') == null) {
		formDacon.setvalue('TIPOAPURACAO', 0);
	}
	if (formDacon.getvalue('IDENTIFICACAOBEM') == null) {
		formDacon.setvalue('IDENTIFICACAOBEM', 1);
	}
	if (formDacon.getvalue('ORIGEMBEM') == null) {
		formDacon.setvalue('ORIGEMBEM', 0);
	}
	if (formDacon.getvalue('UTILIZACAOBEM') == null) {
		formDacon.setvalue('UTILIZACAOBEM', 1);
	}
}

function SetarBASECALCULO() {
	formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');
	formBem = FormManager.byname('TnPatDMPATBEM', '');

	if (formDacon.getvalue('BASECALCULO') == '') {
		formDacon.setvalue('BASECALCULO', formBem.getvalue('VALOR'));
	}
	SetarTIPOS();
}

function SetarDATAINICIAL() {
	formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');
	formBem = FormManager.byname('TnPatDMPATBEM', '');

	if (formDacon.getvalue('DATAINICIAL') == '') {
		formDacon.setvalue('DATAINICIAL', formBem.getvalue('DATAAQUISICAO'));
	}
	SetarTIPOS();
}

function requestTipoConfig() {
	formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');
	formBem = FormManager.byname('TnPatDMPATBEM', '');

	if ((formDacon.getvalue('DATAINICIAL') != '') &&
		(formDacon.getvalue('DATAFINAL') == '')) {
		if (formDacon.getcomponent('CODIGOBEM') != null) {
			$achave = formBem.getvalue('CODIGOBEM') + ';' +
				formDacon.getvalue('TIPODACONCREDITO') + ';' +
				formDacon.getvalue('DATAINICIAL');
		}
		AJaxCadastroExecuteMethodGetProperty('TnPatDMPATCFGDACON',
			'VerificaDataFinalCredito', $achave, '', requestTipoConfigSucesso);
	}
}

function requestTipoConfigSucesso(retorno) {
	formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');
	formDacon.setvalue('DATAFINAL', retorno.data.result);
}

function EnableCamposDacon() {
	formDacon = FormManager.byname('TnPatDMPATCFGDACON', '');

	var tipodacon = parseInt(formDacon.getvalue('TIPODACONCREDITO'));

	var FEnabledRequiredFields = (tipodacon != DACONNAOUTILIZA);
	formDacon.setenabledrequired('DATAFINAL', FEnabledRequiredFields);
	formDacon.setenabledrequired('DATAINICIAL', FEnabledRequiredFields);

	var FEnabledRequiredFields = ($.inArray(tipodacon, [DACON12MESES,
		DACON24MESES,
		DACON48MESES,
		DACON6MESES,
		DACONINTEGRAL,
		DACONMPS]) != -1);

	formDacon.setenabledrequired('BASECALCULO', FEnabledRequiredFields);
}