FormManager.afterCreateAllForms.subscribe(function (){
  // Begin Declarations/Implementations
  const FRMPROCDPAGENDA = "TNQUIUPROCEDIMENTODPAGENDA";
  const MAX_TENTATIVA = 5;
  const TnTPSIM = "1";

  let FFrmProcDPAgenda = null;
  let FParamsProcDPAgenda = null;

  const HabilitarDebug = function() {
    /* Descomentar a linha 'debugger;' e abrir o console do navegador para depurar */
    //debugger;
  }

  const CloseModal = function() {
    window.parent.$('#detalheModal').modal('hide');
  }

  const RetornoStatus = function(json) {
    if (json.data.result != null) {
      if (json.data.result.Status == "1") {
        CloseModal();
      }else if (json.data.result.Tentativa <= MAX_TENTATIVA) {
        let tentativa = json.data.result.Tentativa + 1;
        if (tentativa <= MAX_TENTATIVA) {
          CloseModalStatusConcluido(tentativa);
        }
      }
    }
  }

  const CloseModalStatusConcluido = function(tentativa = 1) {
    setTimeout(() => {
      let AParams = JSON.stringify({"PCODIGOJOB": FParamsProcDPAgenda.PCODIGOJOB, "PCODIGOJOBAGENDA": FParamsProcDPAgenda.PCODIGOJOBAGENDA, "PTENTATIVA": tentativa});
      AJaxProcessoExecuteMethodGetProperty({_AClass: 'TnQuiuDPExecutaAjax',
                                            _AMethodName: 'ConsultaStatusAgenda',
                                            _AValues: AParams,
                                            _ANamePropertys: '',
                                            onSuccess: RetornoStatus});
    }, 1000);
  }

  const OcultarCampos = function (FFrmProcDPAgenda) {
    let EhDiaInteiro = FFrmProcDPAgenda.fieldbyName('PDIAINTEIRO').getvalue() == TnTPSIM;
    let EhPeriodico = FFrmProcDPAgenda.fieldbyName('PPERIODICO').getvalue() == TnTPSIM;

    if ((!EhDiaInteiro) || (!EhPeriodico)) {
      FFrmProcDPAgenda.setvisible('PREPETIRMES', false);
      FFrmProcDPAgenda.setvisible('PREPETIRSEMANA', false);
      FFrmProcDPAgenda.setvisible('PREPETIRMINUTOS', false);
      FFrmProcDPAgenda.setvisible('PACAOFERIADOFINALSEMANA', false);
      for (let i = 1; i < 8; i++) {
        FFrmProcDPAgenda.setvisible('PREPETIRSEMANA_CHECKBOX_' + i, false);
      }
    }
    
    if (!EhPeriodico) {
      FFrmProcDPAgenda.setvisible('PDIAINTEIRO', false);
      FFrmProcDPAgenda.setvisible('PSOBDEMANDA', false);
      FFrmProcDPAgenda.setvisible('PREPETIRCADA', false);
      FFrmProcDPAgenda.setvisible('PPERIODICIDADE', false);
    }
  }

  const DefinirHorario = function (FFrmProcDPAgenda) {
    let Horario = null
    
    if (FParamsProcDPAgenda.PEDITAR == TnTPSIM) {
      Horario = FFrmProcDPAgenda.fieldbyName('PHORARIO').getvalue();
      FFrmProcDPAgenda.fieldbyName('PHORARIO').setvalue(Horario);
    } else {
      Horario = new Date();
      Horario.setMinutes(Horario.getMinutes() + 5);	
      Horario = moment(Horario).format('HH:mm');
      FFrmProcDPAgenda.fieldbyName('PHORARIO').setvalue(Horario);
    }
  }

  // End Declarations/Implementations
  // =================================================================
  // Begin

  //primeiro método sempre
  HabilitarDebug();
  //primeiro método sempre

  if (WizardManager.context.DetalheAtivo == FRMPROCDPAGENDA) {
    FFrmProcDPAgenda = FormManager.byname(FRMPROCDPAGENDA);
    FParamsProcDPAgenda = WizardManager.context.Params;

    OcultarCampos(FFrmProcDPAgenda);
    DefinirHorario(FFrmProcDPAgenda);

    FFrmProcDPAgenda.OnWizardNext.subscribe(CloseModalStatusConcluido);
  }
});