const FORMNAMEPROCDPPAINEL = "TNQUIUPROCEDIMENTODPPAINEL";

var FFormProcDPPainel;

function HabilitarDebug(){
  /* Descomentar a linha 'debugger;' e abrir o console do navegador para depurar */
  //debugger;
}

function showActLote(action) {
  ActLote(action, true);
}

function hideActLote(action) {
  ActLote(action, false);
}

function ActLote(action, condicao) {
  widgetManager.get('AcoesEmLote').setItemVisible(action, condicao);
  widgetManager.get('AcoesEmLote').setItemEnabled(action, condicao);
}

function ActFiltroAgendados(){
	widgetManager.get('Agenda').filter({pWidgetAgendaStatus:'1', pUsarIdRequest:true, idrequest:FFormProcDPPainel.idrequest});

  showActLote('MenuAcoesEmLote');
  showActLote('ExecutarSobDemandaLote');
  hideActLote('ExecutarAgoraEmLote');
  hideActLote('MarcarVerificadoEmLote');
  showActLote('DesativarEmLote');
  hideActLote('ExcluirProcessamentoEmLote');
}

function ActFiltroProcessando(){
	widgetManager.get('Agenda').filter({pWidgetAgendaStatus:'2', pUsarIdRequest:true, idrequest:FFormProcDPPainel.idrequest})
	
	hideActLote(document.querySelector('#widget_AcoesEmLote'));
}

function ActFiltroSucesso(){
	widgetManager.get('Agenda').filter({pWidgetAgendaStatus:'4', pUsarIdRequest:true, idrequest:FFormProcDPPainel.idrequest})  	
	
	hideActLote(document.querySelector('#widget_AcoesEmLote'));
}

function ActFiltroVerificar(){
	widgetManager.get('Agenda').filter({pWidgetAgendaStatus:'5', pUsarIdRequest:true, idrequest:FFormProcDPPainel.idrequest})
	
	showActLote('MenuAcoesEmLote');	
	hideActLote('ExecutarSobDemandaLote');
  showActLote('AgendarEmLote')
	showActLote('ExecutarAgoraEmLote');
	showActLote('MarcarVerificadoEmLote');
	hideActLote('DesativarEmLote');
	showActLote('ExcluirProcessamentoEmLote');
}

function OcultarBotaoExecutar(){
	document.getElementById('btnFiltrar').hidden = true;
}

function AbrirWizardAgendamento(_ANovo){ 
  AbrirProcessoModal({ _AClasse: _ANovo ? 'TnQuiuProcedimentoDPWizardAgendadorInserir' : 'TnDPWizardAgendadorTarefa', form: FFormProcDPPainel});
}

function ValidarRetornoTesteConexao(json){
  if (json.data.result != null){

    if (json.data.result.PlataformaUnica != null){
      if (!json.data.result.PlataformaUnica){
          AbrirWizardAgendamento(json.data.result.Novo);
          return;
      }
    }

    if (json.data.result.Ativo != null){
      if (json.data.result.Ativo){
        AbrirWizardAgendamento(json.data.result.Novo);
      } else {
        FormatErrorMessage(json.data.result.Message);
      }
    }else if (json.data.result.Error != null){
      FormatErrorMessage(json.data.result.Error);
    } else {
      FormatErrorMessage('Não foi possível carregar o retorno!');
    }
  } else {
    FormatErrorMessage('Mensagem de retorno não é válida!');
  }
}

function AgendarProcedimentoQuiu(_ANovo){
  let parametro = new Object()
  parametro.PSERVIDOR = '';
  parametro.PPORTA = '';
  parametro.HORARIO = new Date();
  parametro.PNOVO = _ANovo;
  AJaxProcessoExecuteMethodGetProperty({_AClass: 'TnQuiuDPTestarConexao',
                                        _AMethodName: 'ExecutarViaAjax',
                                        _AValues: JSON.stringify(parametro),
                                        _ANamePropertys: '',
                                        onSuccess: ValidarRetornoTesteConexao});
}

function ActAgendarProcedimentoQuiu(){
  AgendarProcedimentoQuiu(true);
}

function ActAgendarProcedimentoQuiuOld(){
  AgendarProcedimentoQuiu(false);
}

function AtualizarCards(json){
  if (json.data.result != null){
    widgetManager.get('Agendados').setValue({Valor: json.data.result.Agendados});
    widgetManager.get('Processando').setValue({Valor: json.data.result.Processando});
    widgetManager.get('Verificar').setValue({Valor: json.data.result.Verificar});
    widgetManager.get('Sucesso').setValue({Valor: json.data.result.Sucesso});
  }
}

function CountCard(params){
  setTimeout(function(){
    AJaxProcessoExecuteMethodGetProperty({_AClass: 'TnQuiuProcedimentoDPPainel',
                                          _AMethodName: 'ContarCards',
                                          _AValues: JSON.stringify(FFormProcDPPainel.idrequest),
                                          _ANamePropertys: '',
                                          onSuccess: AtualizarCards});
  }, 1000);
}

FormManager.afterCreateAllForms.subscribe(function() {
  HabilitarDebug(); //primeiro método

  FFormProcDPPainel = FormManager.byname(FORMNAMEPROCDPPAINEL);

  OcultarBotaoExecutar();

  widgetManager._widgets.get("Agenda").onFilter().subscribe(CountCard);  
  
  ActFiltroAgendados();  
}); 

function onGetRelatorio(retorno){
  openPdf({
    fileName: retorno.data.result.OrigemPDF,
    fileNameNhz: retorno.data.result.Origem,
    Conteudo: retorno.data.result,
    DefinicaoObjetos: {
        Class: 'nGemRRQuiuProcedimento',
        TipoObjeto: 'ntoRelatorio',
        TopicoAjuda: 'nGemRRQuiuProcedimento',
        ToolButtons: [
            {
                Caption: "Ajuda",
                Classe: "TnDMReport",
                CleanCaption: "Ajuda",
                CloudTipoAcao: "apNone",
                Custom: false,
                ExibirToolBar: true,
                Hint: "Ajuda da janela",
                Name: "ActAjuda",
                NameEvent: "ActAjudaExecute",
                Opcoes: {},
                TipoAcao: "TnAction",
                icon: "data:image/png;base64,Qk02BAAAAAAAADYAAAAoAAAAEAAAABAAAAABACAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAA////AP///wD///8A////AP///wD///8A////AP///wDHmZcAsF9fAI41MgCOLTEAuXttAP///wD///8A////AP///wD///8A////AP///wD///8A////AMuLgQDQsKAAwFcvAOCggADwyLAA8MCgANCQbwCQLw8A////AP///wD///8A////AP///wD///8A////AMCAgADgwLAA0G8/AP/QsAD///AA4MjAAJA/LwD/6NAA8LiQAJAvDwD///8A////AP///wD///8Ax4yKAMCYkADg6OAA4LigAPCwkAD///8A////AODQwADQoJAA/+jgAP/g0ADQkG8At3FnAP///wD///8AwHeAANDIwADw+PAA0MjAAOCATwD/0LAA////AP///wD/8PAAkE8/AMCIbwD/6OAA8MCgAI0rIACrjIoAwJCQAODw4ADg6OAAwJCQAMCIgADwiE8A/9CwAP///wD///8A8OjgAODQ0ACQTz8A0KiQAP/AoACbOS4AwHdvAODo4ADQwMAAwHeAAMCAgADAgIAA8KCAAP/AoAD///8AwIiAAKBXPwDg0NAAoFc/AMCgkADgqIAAwGdfAMCAgADQqLAAwICAANCQkADQkJAA0IiQAOCooAD/qG8A/8iwAPDo4ADAiIAAoFc/AMCIgADwyLAA0G8/ANGSkADQoKAA0KiwANCQkADgoKAA4JigANCYkADQkJAA4KigAP+obwD/wKAA/+DQAP/g0AD/wKAA4IhPANDAsAD///8A////ANCgoADw0NAA0JiQAOCosADgqLAA4KigAOCgoADgsLAA8KiQAP+QXwDwkE8A4KCAANCYkADAZ28AwLCwAP///wD///8A0KCgAPDI0ADQmJAA4LCwAPC4sADgsLAA4KiwAOCgoADgoKAA0JiQANCQkADQiIAAwG9vAMBvbwD///8A////AP///wDQoKAA8MjQANCYkADgsLAA8MDAAPC4sADwsLAA4LCwAOCosADgoKAA0JigANCQkADTjoMA////AP///wD///8A////ANCgoADwyNAA0JiQAPC4sADwyMAA8MDAAPDAwADwuMAA4LCwANCooADdnZAA////AP///wD///8A////AP///wD///8A0KCgAPDI0ADQmJAA8MDAAODAwADgwMAA0KiwANOdkgD///8A////AP///wD///8A////AP///wD///8A////AP///wDQoKAA8NDQAOCgoADQqKAA1KCXAP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ANeemgDWpJsA////AP///wD///8A////AP///wD///8A////AA==",
                tbsButton: true,
            }
        ],
    },
    Params: {
        Class: "nGemRRQuiuProcedimento",
        PCODIGOCFOP: "",
        PCODIGOEMPRESA: "39",
        PCODIGOESTAB: "1",
        PDATAFINAL: "2019-12-31",
        PDATAINICIAL: "2019-11-01",
        PDETALHARNOESTADO: "0",
        PMODELO: "2",
        PQUEBRA: "2",
        PQUEBRAPORMOVIMENTO: "1",
        PTIPOMOVIMENTO: "1;2",
        PTIPOMOVIMENTO_checkbox_1: true,
        PTIPOMOVIMENTO_checkbox_2: true,
        PTIPOTOTAL: "0"
    },
});
}

function ActExecutarRelatorioCloud(params){
  var parametros = gridManager.get("nClientDataSet").getSelectedRowsData()[0]
	let novoparametro = new Object()
  novoparametro.CODIGOJOB = parametros.CODIGOJOB;
  novoparametro.CODIGOJOBCFG = parametros.CODIGOJOBCFG; 
  novoparametro.CODIGOJOBOBJETO = parametros.CODIGOJOBOBJETO 
  AJaxProcessoExecuteMethodGetProperty({
	 	_AClass: 'TnDPJobExecutarRelatorio',
	 	_AMethodName: 'ExecutarRelatorio',
    _AValues: JSON.stringify(novoparametro),
    _ANamePropertys: '',   
	 	onSuccess: onGetRelatorio,
	   });
}