FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnfpaDPCalculoGPS', '');
    form.getcomponent('PCALCULAR').change(DoChangeCalcular);
    $("input[name^='p.PTIPOGPS1']").change(DoChangeTipoGPS);

    DoChangeCalcular();

    function DoChangeCalcular() {
        
        const ACalcular = +form.getvalue('PCALCULAR');
        const CALCULAR_EMPRESA = 1;
        const CALCULAR_FUNCIONARIO = 2;
        const CALCULAR_TERCEIRO = 3;

        if (ACalcular === CALCULAR_EMPRESA) {
            getCheckboxesEmpresa().removeAttr('disabled');
            getCheckboxesFuncionario().prop('checked', false).attr('disabled', 'disabled');  
            getCheckboxesTerceiro().prop('checked', false).attr('disabled', 'disabled');  
        } else if (ACalcular === CALCULAR_FUNCIONARIO) {
            getCheckboxesFuncionario().removeAttr('disabled');
            getCheckboxesEmpresa().prop('checked', false).attr('disabled', 'disabled');  
            getCheckboxesTerceiro().prop('checked', false).attr('disabled', 'disabled');  
        } else if (ACalcular === CALCULAR_TERCEIRO) {
            getCheckboxesTerceiro().removeAttr('disabled');
            getCheckboxesEmpresa().prop('checked', false).attr('disabled', 'disabled');  
            getCheckboxesFuncionario().prop('checked', false).attr('disabled', 'disabled');
        } else {
            getCheckboxesEmpresa().prop('checked', false).attr('disabled', 'disabled');  
            getCheckboxesFuncionario().prop('checked', false).attr('disabled', 'disabled');  
            getCheckboxesTerceiro().prop('checked', false).attr('disabled', 'disabled');  
        }
    }

    function DoChangeTipoGPS(e) {
        const AElement = e.currentTarget;

        const elChecked = form.getvalue(AElement.name.substring(2));

        if (elChecked) {
            /* EMPRESA */
            if (AElement.name === 'p.PTIPOGPS1_checkbox_1') {    
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[2|9]|[1][0]/); }).prop('checked', false);         
            } else if (AElement.name === 'p.PTIPOGPS1_checkbox_2') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[1|9]|[1][0]/); }).prop('checked', false);         
            } else if (AElement.name.match(/p.PTIPOGPS1_checkbox_[3|4]/)) {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[9]/); }).prop('checked', false);         
            }else if (AElement.name === 'p.PTIPOGPS1_checkbox_9') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/^p.PTIPOGPS1_checkbox_[1-4]|[1][0]$/); }).prop('checked', false);         
            } else if (AElement.name === 'p.PTIPOGPS1_checkbox_10') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/^p.PTIPOGPS1_checkbox_[1|2|9]$/); }).prop('checked', false);         
            }
            /* FUNCIONARIO */
            else if (AElement.name === 'p.PTIPOGPS1_checkbox_5') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/^p.PTIPOGPS1_checkbox_[6]$/); }).prop('checked', false);         
            } else if (AElement.name === 'p.PTIPOGPS1_checkbox_6') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/^p.PTIPOGPS1_checkbox_[5]$/); }).prop('checked', false);         
            }
            /* TERCEIRO */
            else if (AElement.name === 'p.PTIPOGPS1_checkbox_7') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/^p.PTIPOGPS1_checkbox_[8]$/); }).prop('checked', false);         
            } else if (AElement.name === 'p.PTIPOGPS1_checkbox_8') {
                $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/^p.PTIPOGPS1_checkbox_[7]$/); }).prop('checked', false);         
            }
        } 

        const elFolhaComplementar = AElement.name.indexOf('p.PTIPOGPS1_checkbox_10') > -1;
        const elReclamatoriaTrabalhista = AElement.name.indexOf('p.PTIPOGPS1_checkbox_9') > -1;
        const elPagamentoRetencaoOutraEmp = AElement.name.indexOf('p.PTIPOGPS1_checkbox_3') > -1;
        if (elFolhaComplementar || elReclamatoriaTrabalhista || elPagamentoRetencaoOutraEmp) {
            const folhaComplementar = isFolhaComplementar();
            const reclamatoriaTrabalhista = isReclamatoriaTrabalhista();
            const pagamentoRetOutraEmp = isPagamentoRetencaoOutraEmpresa();
            
            let AEnabled = folhaComplementar || reclamatoriaTrabalhista;

            form.setenabledrequired('PCODIGOPERCALCULO', AEnabled);
            if (!AEnabled) {
                form.setvalue('PCODIGOPERCALCULO', '');
            }

            AEnabled = pagamentoRetOutraEmp;
            form.setenabledrequired('PCOMPPRODRURAL', AEnabled);
            if (!AEnabled) {
                form.setvalue('PCOMPPRODRURAL', '0');
            }

            AEnabled = reclamatoriaTrabalhista;
            form.setenabled('PCODIGOIMPOSTOCOMPL', AEnabled);
            form.setenabled('PVARIACAOIMPOSTOCOMPL', AEnabled);
            form.setenabled('PIMPOSTOVENC', AEnabled);
			form.setenabledrequired('PIMPOSTOVENC', AEnabled);
			
        }    
    }

    function isFolhaComplementar() {
        return form.getvalue('PTIPOGPS1_checkbox_10');
    }

    function isReclamatoriaTrabalhista() {
        return form.getvalue('PTIPOGPS1_checkbox_9');
    }

    function isPagamentoRetencaoOutraEmpresa() {
        return form.getvalue('PTIPOGPS1_checkbox_3');
    }

    function getCheckboxesEmpresa() {
        return $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[1-4|9]/); });
    }

    function getCheckboxesFuncionario() {
        return $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[5|6]/); });
    }

    function getCheckboxesTerceiro() {
        return $("input[name^='p.PTIPOGPS1']").filter(function() { return this.name.match(/p.PTIPOGPS1_checkbox_[7|8]/); }); 
    }
});

