FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnfpaDPCalculoIntermitente', '');

	formAtual.getcomponent('CODIGOCONVOCACAO').on('blur', () => {
		buscarDatasConvocacao(formAtual.getvalue('CODIGOEMPRESA'), formAtual.getvalue('CODIGOCONVOCACAO'))
			.then((retorno) => {
				let datas = JSON.parse(retorno);
				let mesmaCompet = startOfTheMonth(datas.DataInicial) === startOfTheMonth(datas.DataFinal);
				formAtual.fieldbyName('COMPET').setenabled(!mesmaCompet);
				if (mesmaCompet) formAtual.setvalue('COMPET', startOfTheMonth(datas.DataInicial));
				KTApp.unblockPage();
			});
	});

	formAtual.getcomponent('COMPET').on('blur', () => {
		buscarDatasConvocacao(formAtual.getvalue('CODIGOEMPRESA'), formAtual.getvalue('CODIGOCONVOCACAO'))
			.then((retorno) => {
				let datas = JSON.parse(retorno);
				let mesmaCompet = startOfTheMonth(datas.DataInicial) === startOfTheMonth(datas.DataFinal);
				formAtual.setrequired('DATAPGTO', ((!mesmaCompet) && (startOfTheMonth(moment(formAtual.getvalue('COMPET'), 'YYYY-MM-DD').format('DD/MM/YYYY')) === startOfTheMonth(datas.DataFinal))));
				KTApp.unblockPage();
			});
	});

	async function buscarDatasConvocacao(codigoEmpresa, codigoConvocacao) {
		let Executor = new nExpressionExecutor();
		return await Executor.execute(`EXTERNO("BUSCARDATASCONVOCACAO",[${codigoEmpresa},${codigoConvocacao}])`);
	}

	function startOfTheMonth(data) {
		let date = (new Date(moment(data, 'DD/MM/YYYY').add(1, 'days').format('YYYY-MM-DD')));
		return moment(new Date(date.getFullYear(), date.getMonth(), 1), 'YYYY-MM-DD').format('DD/MM/YYYY');
	}
})