FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnfpaDPExportSal', '');
    form.getcomponent('BANCO').change(DoChangeBanco);
    form.getcomponent('QUALBANCO').change(DoChangeQualBanco);
    form.getcomponent('PEXPORTHOLERIT').change(DoChangeExportHolerit);
    form.getcomponent('CODIGOESTAB').change(DoChangeCodigoEstabOutEmpEmp);
    form.getcomponent('CODIGOOUTEMPEMP').change(DoChangeCodigoEstabOutEmpEmp);
    form.getcomponent('CODIGOBANCO').change(CarregarNumeroSequencia);
    form.getcomponent('AGENCIAEMPRESA').change(CarregarNumeroSequencia);
    form.getcomponent('NUMEROCONTA1').change(CarregarNumeroSequencia);
    $("input[name^='p.GERARVLR']").change(DoChangeGerarVlr);

    form.getcomponent('NUMEROCONTA1').keypress((e) => { if (e.charCode < 48 || e.charCode > 57 ) { event.preventDefault(); } });

    DoChangeCodigoEstabOutEmpEmp();
    DoChangeBanco();
    DoChangeQualBanco();
    DoChangeExportHolerit();

    function DoChangeCodigoEstabOutEmpEmp() {

        let ARequired = +form.getvalue('CODIGOOUTEMPEMP') === 0;
        form.setrequired('CODIGOESTAB', ARequired);    

        if (!ARequired) {
            form.setenabledrequired('AGENCIAOUTRAEMPRESA', true);
            form.setenabledrequired('NUMEROCONTAOUTRAEMPRESA', true);
            form.setrequired('CODIGOOUTEMP', true);

            form.setenabledrequired('AGENCIAEMPRESA', false);
            form.setenabledrequired('NUMEROCONTA1', false);

            form.setvalue('AGENCIAEMPRESA', '');
            form.setvalue('NUMEROCONTA1', '');
        }

        ARequired = +form.getvalue('CODIGOESTAB') === 0;
        form.setrequired('CODIGOOUTEMPEMP', ARequired);

        if (!ARequired && +form.getvalue('CODIGOOUTEMPEMP') === 0) {
            form.setenabledrequired('AGENCIAEMPRESA', true);
            form.setenabledrequired('NUMEROCONTA1', true);
        
            form.setenabledrequired('AGENCIAOUTRAEMPRESA', false);
            form.setenabledrequired('NUMEROCONTAOUTRAEMPRESA', false);
            
            form.setrequired('CODIGOOUTEMP', false);
        
            form.setvalue('AGENCIAOUTRAEMPRESA', '');
            form.setvalue('NUMEROCONTAOUTRAEMPRESA', '');
        }

        form.setvalue('CODIGOOUTEMP', form.getvalue('CODIGOOUTEMPEMP'));

        CarregarNumeroSequencia();
    }

    function CarregarNumeroSequencia() {

        if (form.getvalue('CODIGOEMPRESA') &&
            form.getvalue('CODIGOESTAB') &&
            form.getvalue('CODIGOBANCO') &&
            form.getvalue('AGENCIAEMPRESA') &&
            form.getvalue('NUMEROCONTA1')) {

            KTApp.blockPage();

            AValues = form.getvalue('CODIGOEMPRESA') + ';' +
                      form.getvalue('CODIGOESTAB') + ';' +
                      form.getvalue('CODIGOBANCO') + ';' +
                      form.getvalue('AGENCIAEMPRESA') + ';' +
                      form.getvalue('NUMEROCONTA1');

            AJaxProcessoExecuteMethodGetProperty({
                _AClass: 'TnfpaDPExportSal',
                _AMethodName: 'PegarNumeroSeqs',
                _AValues: AValues,
                _ANamePropertys: '',
                onSuccess: DoPegarNumeroSeqsDone,
                onError: () => { KTApp.unblockPage(); },
            });
        }
    }

    function DoPegarNumeroSeqsDone(retorno) {
        if (retorno.data.result) {
                
            if (retorno.data.result.NumeroSeqArq) {
                form.setvalue('NUMEROSEQARQ', retorno.data.result.NumeroSeqArq);
            }        
            if (retorno.data.result.NumeroSeqHolerit) {
                if (form.getvalue('PEXPORTHOLERIT') == '1') {
                    form.setvalue('NUMEROSEQHOLERIT', retorno.data.result.NumeroSeqHolerit);
                }
            }        
        }    
        KTApp.unblockPage();
    }

    function DoChangeExportHolerit() {

        let AEnabled = (form.getvalue('PEXPORTHOLERIT') == '1');

        form.setenabledrequired('NUMEROSEQHOLERIT', AEnabled);
        form.setenabledrequired('SALARIOPROFESSOR', AEnabled);
        form.setenabledrequired('PDETPLANOSAUDE', AEnabled);
        form.setenabledCheckListBox('PTIPOEVENTOOUTROS', AEnabled);
    }

    function DoChangeGerarVlr() {

        let AGerarVlrs = '';
        $('#ctrlGERARVLRcheck input').each((i, el) => { 
            if ($(el).prop('checked')) {
                AGerarVlrs += el.name.substring(el.name.length - 1) + ';';
            }        
        });

        const AHabilitarFunc = AGerarVlrs.includes('1') || AGerarVlrs.includes('2') || AGerarVlrs.includes('3') || AGerarVlrs.includes('5') || AGerarVlrs === '';
        const AHabilitarTerc = AGerarVlrs.includes('4') || AGerarVlrs === ''

        form.setenabledrequired('FUNCS', AHabilitarFunc);
        if (!AHabilitarFunc) {
            form.setvalue('FUNCS', '');
        }

        if (+form.getvalue('BANCO') !== 10033) {
            form.setenabled('TERCS', AHabilitarTerc);
            form.setenabled('RPAS', AHabilitarTerc);
        }
        
        if (!AHabilitarTerc) {
            form.setvalue('TERCS', '');
            form.setvalue('RPAS', '');   
        }

        form.setrequired('CODIGOPERCALC', AGerarVlrs.includes('1'));    
    }

    function DoChangeQualBanco() {

        AQualBanco = +form.getvalue('QUALBANCO');
        if (AQualBanco === 1) {
            form.setenabled('AGENCIAFUNC', true);
            form.setenabled('IGNORABANCO', false);
            form.setvalue('IGNORABANCO', '');
        } else {
            form.setvalue('AGENCIAFUNC', '');
            form.setenabled('AGENCIAFUNC', false);
            form.setenabled('IGNORABANCO', true);
        }
    }

    function DoChangeBanco() {

        const ABanco = +form.getvalue('BANCO');

        if (ABanco === 10748) {
            form.setvalue('NUMEROSEQARQ', 0);
        }

        const maxValue = getMaxValueFromSelectedBank(ABanco);

        if (ABanco > maxValue) {
            if (ABanco === 1020999) {
                form.setvalue('CODIGOBANCO', ABanco - 1020000);
            } else {
                form.setvalue('CODIGOBANCO', ABanco - maxValue);
            }   
        } else {
            form.setvalue('CODIGOBANCO', ABanco);
        }  

        form.getcomponent('CODIGOBANCO').blur();
        form.setenabled('TIPOOPERACAO', (ABanco === 409));

        let AEnabled = (ABanco === 104);
        form.setenabledrequired('PEMPRESASGERAR', AEnabled);

        if (!AEnabled) {
            form.setvalue('PEMPRESASGERAR', SessionManager.selecao.CODIGOEMPRESA);
        }

        AEnabled = [1, 41, 341].includes(+form.getvalue('CODIGOBANCO'));
        form.setenabled('PEXPORTHOLERIT', AEnabled);

        if (!AEnabled) {
            form.setvalue('PEXPORTHOLERIT', '0');
            form.getcomponent('PEXPORTHOLERIT').change();
        } 
        
        if (ABanco === 10033) {
            form.setvalue('PEXPORTHOLERIT', '1');
            form.getcomponent('PEXPORTHOLERIT').change();

            form.setvalue('TERCS', '');
            form.setvalue('RPAS', '');
            form.setvalue('PENSAOJUD', '');    
            
            form.setenabled('PENSAOJUD', false);
            form.setenabled('TERCS', false);
            form.setenabled('RPAS', false);

            form.setenabled('NUMEROSEQHOLERIT', true);

            form.setenabled('GERARVLR_checkbox_4', false);
            form.setfieldvalue('GERARVLR_checkbox_4', false);
        } else {
            form.setenabled('PENSAOJUD', true);
            form.setenabled('TERCS', true);
            form.setenabled('RPAS', true);
            form.setenabled('GERARVLR_checkbox_4', true);
        }
    }

    function getMaxValueFromSelectedBank(_ABank) {
        const values = [50000, 40000, 30000, 20000, 10000].map((v) => { 
            if (_ABank > v) { 
                return v; 
            } else {
                return 0;
            }
        });

        const maxValue = values.reduce((a, b) => { 
            return Math.max(a, b); 
        });

        return maxValue;
    }    
});