FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnfpaDPSefip', '');
    
    form.getcomponent('COMPET').change(DoChangeCompet);
    form.getcomponent('DATAVCTOGFIP').change(DoChangeDataVctoGFIP);
    form.getcomponent('CODIGOGRUPOPROC').attr('data-haschange', true);
    form.getcomponent('CODIGOGRUPOPROC').change(DoChangeCodigoGrupoProc);
    form.getcomponent('EMPRESAS').attr('data-haschange', true);
    form.getcomponent('EMPRESAS').change(DoControleAtributos);
    form.getcomponent('ESTABS').attr('data-haschange', true);
    form.getcomponent('ESTABS').change(DoControleAtributos);
    form.getcomponent('PGERARPRODUTORRURAL').change(DoHabilitarCodigoFPAS);
    form.getcomponent('ORGANOGRAMA').change(DoChangeOrganograma);
    form.getcomponent('BUSCARPORTEEMP').change(DoChangeBuscarPorteEmp);
    form.getcomponent('TIPOARQ1').change(DoChangeTipoArq1);
    form.getcomponent('MODALIDADEARQUIVO').change(DoChangeModalidadeArquivo);
    form.getcomponent('PCODIGOPERCALCULOAGRUPADOR').attr('data-haschange', true);
    form.getcomponent('PCODIGOPERCALCULOAGRUPADOR').change(DoChangeCodigoPerCalculoAgrupador);
    form.getcomponent('PCODIGOIMPOSTO').change(DoChangeCodigoImposto);

    $(document).ready(function() {
        DoChangeCompet();
        DoChangeModalidadeArquivo();
        DoHabilitarCodigoFPAS();
        DoControleAtributos();
        DoChangeCodigoGrupoProc();
    });

    const CalcularDataRecolhimentoGPS = () => {
        if (form.getvalue('COMPET') && [1, 5].includes(+form.getvalue('TIPOARQ1'))) {
            const AData = moment(form.getvalue('COMPET'), 'YYYY-MM-DD').add(1, 'month').format('YYYY-MM-DD');
            form.setvalue('DATARECOLGPS', AData);
        } else if (+form.getvalue('TIPOARQ1') === 2) {
            form.setvalue('DATARECOLGPS', form.getvalue('COMPET'));
        }
        if (form.getvalue('DATARECOLGPS')) {
            let AData = moment(form.getvalue('DATARECOLGPS'), 'YYYY-MM-DD').add(19, 'day');        
            while (AData.isoWeekday() === 6 || AData.isoWeekday() === 7) {
                AData = AData.subtract(1, 'day');
            }    
            form.setvalue('DATARECOLGPS', AData.format('YYYY-MM-DD'));
        }
    };

    const CalcularDataRecolhimentoGFIP = () => {
        

        if (form.getvalue('COMPET')) {
            const AData = moment(form.getvalue('COMPET'), 'YYYY-MM-DD').add(1, 'month').format('YYYY-MM-DD');
            form.setvalue('DATAVCTOGFIP', AData);
        }
        if (form.getvalue('DATAVCTOGFIP')) {
            let AData = moment(form.getvalue('DATAVCTOGFIP'), 'YYYY-MM-DD').add(6, 'day');        
            while (AData.isoWeekday() === 6 || AData.isoWeekday() === 7) {
                AData = AData.subtract(1, 'day');
            }    
            form.setvalue('DATAVCTOGFIP', AData.format('YYYY-MM-DD'));
            form.setvalue('DATARECOLGFIP', AData.format('YYYY-MM-DD'));
        }
    };

    const AtribuirOpcoesGerarProdutorRural = () => {
        let AProdutorRuralOpts = [];
        
        const AGerarProdutorRuralEl = form.getcomponent('PGERARPRODUTORRURAL');
        
        AGerarProdutorRuralEl.empty();
        if (moment(form.getvalue('COMPET'), 'YYYY-MM-DD').toDate() >= moment('01/01/2018', 'DD/MM/YYYY').toDate()) {
            AProdutorRuralOpts.push({value: '1', option: 'Não'});
            AProdutorRuralOpts.push({value: '2', option: 'Sim'});
        } else {
            AProdutorRuralOpts.push({value: '1', option: 'Normal'});
            AProdutorRuralOpts.push({value: '2', option: 'Com Liminar'});
        }
        
        $.each(AProdutorRuralOpts, function(idx, value) {
            AGerarProdutorRuralEl.append($("<option></option>").attr("value", value.value).text(value.option));
          });

        form.setvalue('PGERARPRODUTORRURAL', '1');
    };

    function DoChangeDataVctoGFIP() {
        
        if (form.getvalue('DATAVCTOGFIP')) {
            form.setvalue('DATARECOLGFIP', form.getvalue('DATAVCTOGFIP'));    
        }
    }

    function DoChangeCompet() {
        CalcularDataRecolhimentoGPS();
        CalcularDataRecolhimentoGFIP();    
        AtribuirOpcoesGerarProdutorRural();    
    }

    function DoChangeCodigoImposto() {
        const AAtivar = ehImposto650660();
        form.setenabled('PCODIGOPERCALCULOAGRUPADOR', AAtivar);
        form.setenabled('PCOMPETINI', AAtivar);
        form.setenabled('PCOMPETFIM', AAtivar);

        if (AAtivar) {
            form.setvalue('TIPOARQ1', '5')
        } else {
            LimparAgrupadorPeriodo();
            if (form.getvalue('TIPOARQ1') == '5') {
                form.setvalue('TIPOARQ1', '1');
            }
        }    
    }

    function DoChangeCodigoPerCalculoAgrupador(e) {
        KTApp.blockPage();

        
        const AAtivar = form.getvalue('PCODIGOPERCALCULOAGRUPADOR') == '';
        form.setenabled('PCOMPETINI', AAtivar);
        form.setenabled('PCOMPETFIM', AAtivar);

        const DoPegarDadosPeriodoCalculoAgrupadorDone = (retorno) => {
            if (retorno.data) {
                
                form.setvalue('COMPET', moment(retorno.data.result.Compet, 'DD/MM/YYYY').format('YYYY-MM-DD'));
                form.setvalue('PCOMPETINI', retorno.data.result.PeriodoInicial);
                form.setvalue('PCOMPETFIM', retorno.data.result.PeriodoFinal);
            }
            KTApp.unblockPage();
            nextFocus(e.currentTarget, window.event.shiftKey ? -1 : 1);  
        };  

            
        AJaxProcessoExecuteMethodGetProperty({
            _AClass: 'TnfpaDPSefip',
            _AMethodName: 'PegarDadosPeriodoCalculoAgrupador',
            _AValues: +form.getvalue('PCODIGOPERCALCULOAGRUPADOR'),
            _ANamePropertys: '',
            onSuccess: DoPegarDadosPeriodoCalculoAgrupadorDone,
        });
    }

    function DoChangeModalidadeArquivo() {
        const AModalidade = form.getvalue('MODALIDADEARQUIVO');

        if ((AModalidade == '0') || (AModalidade == '7')) {
            form.getcomponent('FUNCSFILTRO').parents('.form-group').find('label').text('Funcionários a Declarar');
        } else {
            form.getcomponent('FUNCSFILTRO').parents('.form-group').find('label').text('Funcionários a Recolher');
        }

        if ((form.getvalue('TIPOARQ1') == '2') && (form.getvalue('MODALIDADEARQUIVO') == '0')) {
            form.setvalue('MODALIDADEARQUIVO', '1');
            qNotifier.warning('Modalidade não permitida para esse tipo de arquivo.');
        }  
    }

    function DoChangeTipoArq1() {
        

        if (form.getvalue('TIPOARQ1') == '1') {
            form.setvalue('MODALIDADEARQUIVO', '0');
      
            if (ehImposto650660()) {
                form.setvalue('PCODIGOIMPOSTO', '');
                LimparAgrupadorPeriodo();
            }
        }
        else if (form.getvalue('TIPOARQ1') == '5') {
            form.setvalue('MODALIDADEARQUIVO', '0');
        
            if (!ehImposto650660()) {
                form.setvalue('PCODIGOIMPOSTO', '');            
            }
        } else {
            form.setvalue('MODALIDADEARQUIVO', '1');
        }

        CalcularDataRecolhimentoGPS();
    }

    function LimparAgrupadorPeriodo() {
        form.setvalue('PCODIGOPERCALCULOAGRUPADOR', '');
        form.setvalue('PCOMPETINI', '');
        form.setvalue('PCOMPETFIM', '');
    }

    function ehImposto650660() {
        return (form.getvalue('PCODIGOIMPOSTO') == 650 || form.getvalue('PCODIGOIMPOSTO') ==  660);
    }

    function DoChangeBuscarPorteEmp() {
        
        const AAtivar = form.getvalue('BUSCARPORTEEMP') == '2';
        form.setenabled('CODIGOOUTEMP', AAtivar);
        if (!AAtivar) {
            form.setvalue('CODIGOOUTEMP', '');
        }
    }

    function DoChangeOrganograma() {
        DoHabilitarCodigoFPAS();
        form.setenabled('CODIGOOUTEMP', +form.getvalue('Organograma') === 0);
        form.setenabled('BUSCARPORTEEMP', +form.getvalue('Organograma') === 0);
        if (!form.enabled('BUSCARPORTEEMP')) {
            form.setvalue('BUSCARPORTEEMP', 1);
            form.setvalue('CODIGOOUTEMP', '');
        }
    }

    function DoHabilitarCodigoFPAS() {
        form.setenabled('CodigoFPAS', (form.getvalue('Organograma') == '1') || (form.getvalue('pGerarProdutorRural') == 2));    
    }

    function DoControleAtributos(e) {

        let AEstabs = true;
        let AFuncs = true;
        let ATercs = true;
      
        const AEmpresas = form.getvalue('EMPRESAS').trim();
        
        if ((!AEmpresas) || (AEmpresas.indexOf('..') + AEmpresas.indexOf(';') > 0)) {
            form.setvalue('ESTABS', '');
            form.setvalue('FUNCS', '');
            form.setvalue('TERCS', '');
            AEstabs = false;
            AFuncs = false;
            ATercs = false;
        } else if (form.getvalue('ESTABS').trim()) {
            form.setvalue('FUNCS', '');
            form.setvalue('TERCS', '');
            AFuncs = false;
            ATercs = false;
        }
        form.setenabled('ESTABS', AEstabs);
        form.setenabled('FUNCS', AFuncs);
        form.setenabled('TERCS', ATercs);

        if (e) {
            nextFocus(e.currentTarget, window.event.shiftKey ? -1 : 1);
        }
    }

    function DoChangeCodigoGrupoProc(e) {
        const AAtivar = +form.getvalue('CodigoGrupoProc') === 0;

        form.setenabled('EMPRESAS', AAtivar);
        form.setenabled('ESTABS', AAtivar);
        form.setenabled('FUNCS', AAtivar);
        form.setenabled('TERCS', AAtivar);
        if (!AAtivar) {
            form.setvalue('EMPRESAS', '');
            form.setvalue('ESTABS', '');
            form.setvalue('FUNCS', '');
            form.setvalue('TERCS', '');
        } else {
            if (form.getvalue('EMPRESAS') != SessionManager.selecao.CODIGOEMPRESA)
                form.setvalue('EMPRESAS', SessionManager.selecao.CODIGOEMPRESA);
        }

        if (e) {
            nextFocus(e.currentTarget, window.event.shiftKey ? -1 : 1);
        }
    }
});




