FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnfpaDPTransfFunc', '');

    form.setvalue('DATAHORACADASTDEST', new Date());
    form.getcomponent('PCODIGOEMPRESADESTINO').blur(sugerirProximoCodigo);

    function sugerirProximoCodigo() {
        let codigoEmpresaDest = form.getvalue('PCODIGOEMPRESADESTINO');
        let codigoFuncContrOrig = form.getvalue('CODIGOFUNCCONTRORIG');

        if ((codigoEmpresaDest) && (codigoFuncContrOrig)) {
            let params = JSON.stringify({
                'CODIGOEMPRESADEST': codigoEmpresaDest,
                'CODIGOFUNCCONTRORIG': codigoFuncContrOrig
            });

            KTApp.blockPage();
            AJaxProcessoExecuteMethodGetProperty({
                _AClass: 'TnfpaDPTransfFunc',
                _AMethodName: 'ProximoContratoDestinoAjax',
                _AValues: params,
                _ANamePropertys: '',
                onSuccess: function (retorno) {
                    if (retorno.data.result) {
                        form.setvalue('CODIGOFUNCCONTRDEST', retorno.data.result);
                        if (ehTransferenciaEmpresa()) {
                            form.setvalue('PMATRICULAESOCIALDEST', retorno.data.result);
                        }
                    }
                },
            });
            KTApp.unblockPage();
        }
    }

    function ehTransferenciaEmpresa() {
        return form.getvalue('PTRANSFERENCIA') === '1';
    }
});
