/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.file.FileHandler;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetException;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.asset.struct.AssetHeader;
import info.ata4.unity.asset.struct.AssetRef;
import info.ata4.unity.asset.struct.AssetRefTable;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.asset.struct.ObjectPathTable;
import info.ata4.unity.asset.struct.TypeTree;
import info.ata4.unity.serdes.db.StructDatabase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class AssetFile
extends FileHandler {
    private static final Logger L = LogUtils.getLogger();
    private AssetHeader header = new AssetHeader();
    private TypeTree typeTree = new TypeTree();
    private ObjectPathTable objTable = new ObjectPathTable();
    private AssetRefTable refTable = new AssetRefTable();
    private AssetBundle sourceBundle;
    private ByteBuffer bbData;
    private ByteBuffer bbAudio;

    public void open(Path file) throws IOException {
        this.load(file, true);
    }

    public void load(Path file) throws IOException {
        this.load(file, false);
    }

    private void load(Path file, boolean map) throws IOException {
        ByteBuffer bb;
        this.setSourceFile(file);
        String fileName = file.getFileName().toString();
        String fileExt = FilenameUtils.getExtension(fileName);
        if (fileExt.startsWith("split")) {
            String splitName;
            Path part;
            fileName = FilenameUtils.removeExtension(fileName);
            ArrayList<Path> parts = new ArrayList<Path>();
            int splitIndex = 0;
            while (!Files.notExists(part = file.resolveSibling(splitName = String.format("%s.split%d", fileName, splitIndex)), new LinkOption[0])) {
                ++splitIndex;
                parts.add(part);
            }
            bb = ByteBufferUtils.load(parts);
        } else {
            bb = map ? ByteBufferUtils.openReadOnly((Path)file) : ByteBufferUtils.load((Path)file);
        }
        Path audioStreamFile = file.resolveSibling(fileName + ".resS");
        if (Files.exists(audioStreamFile, new LinkOption[0])) {
            this.bbAudio = ByteBufferUtils.openReadOnly((Path)audioStreamFile);
        }
        this.load(bb);
    }

    public void load(ByteBuffer bb) throws IOException {
        DataInputReader in = DataInputReader.newReader((ByteBuffer)bb);
        in.readStruct((Struct)this.header);
        in.setSwap(true);
        this.typeTree = new TypeTree();
        this.objTable = new ObjectPathTable();
        this.refTable = new AssetRefTable();
        this.typeTree.setFormat(this.header.getFormat());
        switch (this.header.getFormat()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int treeOffset = this.header.getFileSize() - this.header.getTreeSize() + 1;
                this.bbData = ByteBufferUtils.getSlice((ByteBuffer)bb, (int)0, (int)treeOffset);
                bb.position(treeOffset);
                in.readStruct((Struct)this.typeTree);
                in.readStruct((Struct)this.objTable);
                in.readStruct((Struct)this.refTable);
                break;
            }
            case 9: {
                in.readStruct((Struct)this.typeTree);
                in.readStruct((Struct)this.objTable);
                in.readStruct((Struct)this.refTable);
                this.bbData = ByteBufferUtils.getSlice((ByteBuffer)bb, (int)this.header.getDataOffset());
                break;
            }
            default: {
                throw new AssetException("Unknown asset format " + this.header.getFormat());
            }
        }
        if (this.typeTree.getFields().isEmpty()) {
            L.info("Standalone asset file detected, using structure from database");
            StructDatabase.getInstance().fill(this);
        }
    }

    public void save(Path file) throws IOException {
        if (this.header.getFormat() != 9) {
            throw new AssetException("Only format 9 is supported right now");
        }
        ByteArrayOutputStream bosStruct = new ByteArrayOutputStream();
        DataOutputWriter outStruct = DataOutputWriter.newWriter((OutputStream)bosStruct);
        outStruct.setSwap(true);
        this.typeTree.setFormat(this.header.getFormat());
        this.typeTree.write(outStruct);
        this.objTable.write(outStruct);
        this.refTable.write(outStruct);
        int structSize = bosStruct.size();
        int structAlign = 16;
        outStruct.align(structAlign);
        ByteBuffer bbStruct = ByteBuffer.wrap(bosStruct.toByteArray());
        int minSize = 4096;
        int padding = Math.max(0, minSize - 20 - bbStruct.limit());
        this.header.setTreeSize(structSize);
        this.header.setDataOffset(20 + bbStruct.limit() + padding);
        this.header.setFileSize(this.header.getDataOffset() + this.bbData.limit());
        MappedByteBuffer bb = ByteBufferUtils.openReadWrite((Path)file, (int)0, (int)this.header.getFileSize());
        DataOutputWriter out = DataOutputWriter.newWriter((ByteBuffer)bb);
        this.header.write(out);
        bb.put(bbStruct);
        out.skipBytes(padding);
        bb.put(this.bbData);
    }

    public AssetBundle getSourceBundle() {
        return this.sourceBundle;
    }

    public void setSourceBundle(AssetBundle sourceBundle) {
        this.sourceBundle = sourceBundle;
    }

    public ByteBuffer getDataBuffer() {
        return this.bbData;
    }

    public void setDataBuffer(ByteBuffer bbData) {
        this.bbData = bbData;
    }

    public ByteBuffer getAudioBuffer() {
        return this.bbAudio;
    }

    public void setAudioBuffer(ByteBuffer bbAudio) {
        this.bbAudio = bbAudio;
    }

    public AssetHeader getHeader() {
        return this.header;
    }

    public TypeTree getTypeTree() {
        return this.typeTree;
    }

    public List<ObjectPath> getPaths() {
        return this.objTable.getPaths();
    }

    public List<AssetRef> getReferences() {
        return this.refTable.getReferences();
    }

    public Set<Integer> getClassIDs() {
        TreeSet<Integer> classIDs = new TreeSet<Integer>();
        for (ObjectPath path : this.objTable.getPaths()) {
            classIDs.add(path.getClassID());
        }
        return classIDs;
    }

    public ByteBuffer getPathBuffer(ObjectPath path) {
        return ByteBufferUtils.getSlice((ByteBuffer)this.getDataBuffer(), (int)path.getOffset(), (int)path.getLength());
    }
}

