/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset.bundle;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.file.FileHandler;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.bundle.AssetBundleException;
import info.ata4.unity.asset.bundle.codec.AssetBundleCodec;
import info.ata4.unity.asset.bundle.codec.XianjianCodec;
import info.ata4.unity.asset.bundle.struct.AssetBundleHeader;
import info.ata4.unity.util.UnityVersion;
import info.ata4.util.io.lzma.LzmaBufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AssetBundle
extends FileHandler {
    private static final Logger L = LogUtils.getLogger();
    private static final int ALIGN = 4;
    private final List<AssetBundleCodec> codecsLoad = new ArrayList<AssetBundleCodec>();
    private final List<AssetBundleCodec> codecsSave = new ArrayList<AssetBundleCodec>();
    private final AssetBundleHeader header = new AssetBundleHeader();
    private final Map<String, ByteBuffer> entries = new LinkedHashMap<String, ByteBuffer>();
    private boolean compressed = false;

    private static int align(int length) {
        int rem = length % 4;
        if (rem != 0) {
            length += 4 - rem;
        }
        return length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAssetBundle(Path file) {
        try (DataInputReader in = DataInputReader.newReader((Path)file);){
            AssetBundleHeader info = new AssetBundleHeader();
            info.setSignature(in.readStringNull());
            boolean bl = info.hasValidSignature();
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public AssetBundle() {
        this.codecsLoad.add(new XianjianCodec());
    }

    public void load(ByteBuffer bb) throws IOException {
        for (AssetBundleCodec codec : this.codecsLoad) {
            if (!codec.isEncoded(bb)) continue;
            L.log(Level.INFO, "Decoding: {0}", codec.getName());
            bb = codec.decode(bb);
            this.codecsSave.add(codec);
        }
        DataInputReader in = DataInputReader.newReader((ByteBuffer)bb);
        in.readStruct((Struct)this.header);
        if (!this.header.hasValidSignature()) {
            throw new AssetBundleException("Invalid signature");
        }
        this.compressed = this.header.isCompressed();
        ByteBuffer bbData = ByteBufferUtils.getSlice((ByteBuffer)bb, (int)this.header.getDataOffset());
        if (this.isCompressed()) {
            L.log(Level.INFO, "Uncompressing asset bundle, this may take a while");
            bbData = LzmaBufferUtils.decode(bbData);
        }
        in = DataInputReader.newReader((ByteBuffer)bbData);
        int files = in.readInt();
        for (int i = 0; i < files; ++i) {
            String name = in.readStringNull();
            int offset = in.readInt();
            int length = in.readInt();
            ByteBuffer bbEntry = ByteBufferUtils.getSlice((ByteBuffer)bbData, (int)offset, (int)length);
            this.entries.put(name, bbEntry);
        }
    }

    public void save(Path file) throws IOException {
        int dataSizeC;
        int bundleHeaderSize = 4;
        int bundleDataSize = 0;
        int assets = 0;
        Set<Map.Entry<String, ByteBuffer>> entrySet = this.entries.entrySet();
        for (Map.Entry<String, ByteBuffer> entry : entrySet) {
            String name = entry.getKey();
            ByteBuffer buffer = entry.getValue();
            bundleHeaderSize += name.length() + 9;
            if (name.equals("mainData") || name.startsWith("level") || name.startsWith("CAB")) {
                ++assets;
            }
            bundleDataSize += AssetBundle.align(buffer.limit());
        }
        int bundleDataOffset = AssetBundle.align(bundleHeaderSize);
        ByteBuffer bbData = ByteBuffer.allocateDirect(bundleDataOffset + bundleDataSize);
        DataOutputWriter out = DataOutputWriter.newWriter((ByteBuffer)bbData.duplicate());
        out.writeInt(entrySet.size());
        for (Map.Entry<String, ByteBuffer> entry : entrySet) {
            String name = entry.getKey();
            ByteBuffer buffer = entry.getValue();
            buffer.rewind();
            out.writeStringNull(name);
            out.writeInt(bundleDataOffset);
            out.writeInt(buffer.limit());
            bbData.position(bundleDataOffset);
            bbData.put(buffer);
            bundleDataOffset += AssetBundle.align(buffer.limit());
        }
        bbData.flip();
        int dataSizeU = dataSizeC = bbData.limit();
        if (this.isCompressed()) {
            L.log(Level.INFO, "Compressing asset bundle, this may take a while");
            bbData = LzmaBufferUtils.encode(bbData);
            dataSizeC = bbData.limit();
        }
        int headerSize = this.header.getSize();
        int bundleSize = headerSize + dataSizeC;
        this.header.setCompressed(this.isCompressed());
        this.header.setDataOffset(headerSize);
        this.header.setFileSize1(bundleSize);
        this.header.setFileSize2(bundleSize);
        this.header.setUnknown1(assets);
        this.header.setUnknown2(bundleHeaderSize);
        List<Pair<Integer, Integer>> offsetMap = this.header.getOffsetMap();
        offsetMap.clear();
        for (int i = 0; i < assets; ++i) {
            offsetMap.add(new ImmutablePair<Integer, Integer>(dataSizeC, dataSizeU));
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(bundleSize);
        out = DataOutputWriter.newWriter((ByteBuffer)bb);
        out.writeStruct((Struct)this.header);
        out.writeBuffer(bbData);
        bb.flip();
        for (AssetBundleCodec codec : this.codecsSave) {
            L.log(Level.INFO, "Encoding: {0}", codec.getName());
            bb = codec.encode(bb);
        }
        bb.rewind();
        ByteBufferUtils.save((Path)file, (ByteBuffer)bb);
    }

    public Map<String, ByteBuffer> getEntries() {
        return this.entries;
    }

    public List<AssetBundleCodec> getLoadCodecs() {
        return this.codecsLoad;
    }

    public List<AssetBundleCodec> getSaveCodecs() {
        return this.codecsSave;
    }

    public int getFormat() {
        return this.header.getFormat();
    }

    public void setFormat(byte format) {
        this.header.setFormat(format);
    }

    public UnityVersion getPlayerVersion() {
        return this.header.getPlayerVersion();
    }

    public void setPlayerVersion(UnityVersion version) {
        this.header.setPlayerVersion(version);
    }

    public UnityVersion getEngineVersion() {
        return this.header.getEngineVersion();
    }

    public void setEngineVersion(UnityVersion revision) {
        this.header.setEngineVersion(revision);
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }
}

