/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset.bundle.struct;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import info.ata4.unity.util.UnityVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AssetBundleHeader
implements Struct {
    public static final String SIGNATURE_WEB = "UnityWeb";
    public static final String SIGNATURE_RAW = "UnityRaw";
    private String signature;
    private int format;
    private UnityVersion versionPlayer;
    private UnityVersion versionEngine;
    private int fileSize1;
    private int dataOffset;
    private int unknown1;
    private List<Pair<Integer, Integer>> offsetMap = new ArrayList<Pair<Integer, Integer>>();
    private int fileSize2;
    private int unknown2;

    public void read(DataInputReader in) throws IOException {
        this.signature = in.readStringNull();
        this.format = in.readInt();
        this.versionPlayer = new UnityVersion(in.readStringNull());
        this.versionEngine = new UnityVersion(in.readStringNull());
        this.fileSize1 = in.readInt();
        this.dataOffset = in.readInt();
        this.unknown1 = in.readInt();
        int assets = in.readInt();
        assert (this.unknown1 == assets || this.unknown1 == 1);
        for (int i = 0; i < assets; ++i) {
            this.offsetMap.add(new ImmutablePair<Integer, Integer>(in.readInt(), in.readInt()));
        }
        if (this.format >= 2) {
            this.fileSize2 = in.readInt();
            assert (this.fileSize1 <= this.fileSize2);
        }
        if (this.format >= 3) {
            this.unknown2 = in.readInt();
        }
        in.readByte();
    }

    public void write(DataOutputWriter out) throws IOException {
        out.writeStringNull(this.signature);
        out.writeInt(this.format);
        out.writeStringNull(this.versionPlayer.toString());
        out.writeStringNull(this.versionEngine.toString());
        out.writeInt(this.fileSize1);
        out.writeInt(this.dataOffset);
        out.writeInt(this.unknown1);
        out.writeInt(this.offsetMap.size());
        for (Pair<Integer, Integer> offset : this.offsetMap) {
            out.writeInt(offset.getLeft().intValue());
            out.writeInt(offset.getRight().intValue());
        }
        if (this.format >= 2) {
            out.writeInt(this.fileSize2);
        }
        if (this.format >= 3) {
            out.writeInt(this.unknown2);
        }
        out.writeByte(0);
    }

    public int getSize() {
        int size = 0;
        size += this.signature.length() + 1;
        size += 4;
        size += this.versionPlayer.toString().length() + 1;
        size += this.versionEngine.toString().length() + 1;
        size += 16;
        size += this.offsetMap.size() * 8;
        if (this.format >= 2) {
            size += 4;
        }
        if (this.format >= 3) {
            size += 4;
        }
        return ++size;
    }

    public boolean hasValidSignature() {
        return this.signature.equals(SIGNATURE_WEB) || this.signature.equals(SIGNATURE_RAW);
    }

    public boolean setCompressed(boolean compressed) {
        return this.signature.equals(compressed ? SIGNATURE_WEB : SIGNATURE_RAW);
    }

    public boolean isCompressed() {
        return this.signature.equals(SIGNATURE_WEB);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(byte format) {
        this.format = format;
    }

    public UnityVersion getPlayerVersion() {
        return this.versionPlayer;
    }

    public void setPlayerVersion(UnityVersion version) {
        this.versionPlayer = version;
    }

    public UnityVersion getEngineVersion() {
        return this.versionEngine;
    }

    public void setEngineVersion(UnityVersion revision) {
        this.versionEngine = revision;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(int dataOffset) {
        this.dataOffset = dataOffset;
    }

    public List<Pair<Integer, Integer>> getOffsetMap() {
        return this.offsetMap;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public void setUnknown1(int unknown1) {
        this.unknown1 = unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public void setUnknown2(int unknown2) {
        this.unknown2 = unknown2;
    }

    public int getFileSize1() {
        return this.fileSize1;
    }

    public void setFileSize1(int fileSize1) {
        this.fileSize1 = fileSize1;
    }

    public int getFileSize2() {
        return this.fileSize2;
    }

    public void setFileSize2(int fileSize2) {
        this.fileSize2 = fileSize2;
    }
}

