/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset.struct;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TypeField
implements Struct {
    public static final int FLAG_FORCE_ALIGN = 16384;
    private final List<TypeField> children = new ArrayList<TypeField>();
    private String type;
    private String name;
    private int size;
    private int index;
    private int arrayFlag;
    private int flags1;
    private int flags2;

    public boolean isForceAlign() {
        return (this.flags2 & 0x4000) != 0;
    }

    public void setForceAlign(boolean forceAlign) {
        this.flags2 = forceAlign ? (this.flags2 |= 0x4000) : (this.flags2 &= 0xFFFFBFFF);
    }

    public List<TypeField> getChildren() {
        return this.children;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getArrayFlag() {
        return this.arrayFlag;
    }

    public void setArrayFlag(int arrayFlag) {
        this.arrayFlag = arrayFlag;
    }

    public int getFlags1() {
        return this.flags1;
    }

    public void setFlags1(int flags1) {
        this.flags1 = flags1;
    }

    public int getFlags2() {
        return this.flags2;
    }

    public void setFlags2(int flags2) {
        this.flags2 = flags2;
    }

    public String toString() {
        return this.type + ":" + this.name;
    }

    public void read(DataInputReader in) throws IOException {
        this.type = in.readStringNull(256);
        this.name = in.readStringNull(256);
        this.size = in.readInt();
        this.index = in.readInt();
        this.arrayFlag = in.readInt();
        this.flags1 = in.readInt();
        this.flags2 = in.readInt();
        int numChildren = in.readInt();
        for (int i = 0; i < numChildren; ++i) {
            TypeField fn = new TypeField();
            fn.read(in);
            this.children.add(fn);
        }
    }

    public void write(DataOutputWriter out) throws IOException {
        out.writeStringNull(this.type);
        out.writeStringNull(this.name);
        out.writeInt(this.size);
        out.writeInt(this.index);
        out.writeInt(this.arrayFlag);
        out.writeInt(this.flags1);
        out.writeInt(this.flags2);
        out.writeInt(this.children.size());
        for (TypeField subField : this.children) {
            subField.write(out);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeField other = (TypeField)obj;
        if (!Objects.equals(this.children, other.children)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return this.arrayFlag == other.arrayFlag;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.children);
        hash = 31 * hash + Objects.hashCode(this.type);
        hash = 31 * hash + Objects.hashCode(this.name);
        hash = 31 * hash + this.size;
        hash = 31 * hash + this.index;
        hash = 31 * hash + this.arrayFlag;
        return hash;
    }
}

