/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset.struct;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import info.ata4.unity.asset.struct.TypeField;
import info.ata4.unity.util.UnityVersion;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class TypeTree
implements Struct {
    private final Map<Integer, TypeField> classes = new LinkedHashMap<Integer, TypeField>();
    private UnityVersion engineVersion;
    private int treeVersion;
    private int treeFormat;

    public Map<Integer, TypeField> getFields() {
        return this.classes;
    }

    public UnityVersion getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(UnityVersion engineVersion) {
        this.engineVersion = engineVersion;
    }

    public int getVersion() {
        return this.treeVersion;
    }

    public void setVersion(int version) {
        this.treeVersion = version;
    }

    public int getFormat() {
        return this.treeFormat;
    }

    public void setFormat(int format) {
        this.treeFormat = format;
    }

    public void read(DataInputReader in) throws IOException {
        if (this.treeFormat >= 7) {
            this.engineVersion = new UnityVersion(in.readStringNull(255));
            this.treeVersion = in.readInt();
        }
        if (this.treeFormat <= 5) {
            in.setSwap(false);
        }
        int fields = in.readInt();
        for (int i = 0; i < fields; ++i) {
            int classID = in.readInt();
            TypeField fn = new TypeField();
            fn.read(in);
            this.classes.put(classID, fn);
        }
        if (this.treeFormat >= 7) {
            in.readInt();
        }
    }

    public void write(DataOutputWriter out) throws IOException {
        if (this.treeFormat >= 7) {
            out.writeStringNull(this.engineVersion.toString());
            out.writeInt(this.treeVersion);
        }
        if (this.treeFormat <= 5) {
            out.setSwap(false);
        }
        if (this.classes.isEmpty()) {
            int fields = this.classes.size();
            out.writeInt(fields);
            for (Map.Entry<Integer, TypeField> entry : this.classes.entrySet()) {
                int classID = entry.getKey();
                out.writeInt(classID);
                TypeField fn = entry.getValue();
                fn.write(out);
            }
        } else {
            out.writeInt(0);
        }
        if (this.treeFormat >= 7) {
            out.writeInt(0);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeTree other = (TypeTree)obj;
        if (!Objects.equals(this.classes, other.classes)) {
            return false;
        }
        if (!Objects.equals(this.engineVersion, other.engineVersion)) {
            return false;
        }
        if (this.treeVersion != other.treeVersion) {
            return false;
        }
        return this.treeFormat == other.treeFormat;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.classes);
        hash = 29 * hash + Objects.hashCode(this.engineVersion);
        hash = 29 * hash + this.treeVersion;
        hash = 29 * hash + this.treeFormat;
        return hash;
    }
}

