/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import info.ata4.log.LogUtils;
import info.ata4.unity.DisUnity;
import info.ata4.unity.cli.DisUnityOptions;
import info.ata4.unity.cli.cmd.BundleExtractCmd;
import info.ata4.unity.cli.cmd.BundleInjectCmd;
import info.ata4.unity.cli.cmd.BundleListCmd;
import info.ata4.unity.cli.cmd.Command;
import info.ata4.unity.cli.cmd.DebugDeserializerCmd;
import info.ata4.unity.cli.cmd.DebugStructDBCmd;
import info.ata4.unity.cli.cmd.DumpCmd;
import info.ata4.unity.cli.cmd.DumpStructCmd;
import info.ata4.unity.cli.cmd.ExtractCmd;
import info.ata4.unity.cli.cmd.ExtractRawCmd;
import info.ata4.unity.cli.cmd.ExtractStructCmd;
import info.ata4.unity.cli.cmd.ExtractTxtCmd;
import info.ata4.unity.cli.cmd.InfoCmd;
import info.ata4.unity.cli.cmd.LearnCmd;
import info.ata4.unity.cli.cmd.ListCmd;
import info.ata4.unity.cli.cmd.SplitCmd;
import info.ata4.unity.cli.cmd.StatsCmd;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DisUnityCli
implements Runnable {
    private static final Logger L = LogUtils.getLogger();
    private final DisUnityOptions opts = new DisUnityOptions();
    private final JCommander jc = new JCommander();

    public DisUnityCli() {
        this.jc.setProgramName(DisUnity.getProgramName());
        this.jc.addObject((Object)this.opts);
        PrintStream out = System.out;
        this.jc.addCommand((Object)new DumpCmd());
        this.jc.addCommand((Object)new DumpStructCmd());
        this.jc.addCommand((Object)new ExtractCmd());
        this.jc.addCommand((Object)new ExtractRawCmd());
        this.jc.addCommand((Object)new ExtractTxtCmd());
        this.jc.addCommand((Object)new ExtractStructCmd());
        this.jc.addCommand((Object)new InfoCmd(out));
        this.jc.addCommand((Object)new StatsCmd(out));
        this.jc.addCommand((Object)new LearnCmd());
        this.jc.addCommand((Object)new ListCmd(out));
        this.jc.addCommand((Object)new SplitCmd());
        this.jc.addCommand((Object)new BundleExtractCmd());
        this.jc.addCommand((Object)new BundleInjectCmd());
        this.jc.addCommand((Object)new BundleListCmd(out));
        this.jc.addCommand((Object)new DebugDeserializerCmd());
        this.jc.addCommand((Object)new DebugStructDBCmd());
    }

    public void parse(String[] args) {
        L.info(DisUnity.getSignature());
        this.jc.parse(args);
        if (this.opts.isHelp()) {
            this.jc.usage();
        }
        if (this.opts.isVerbose()) {
            LogUtils.configure((Level)Level.ALL);
        }
    }

    @Override
    public void run() {
        if (this.opts.isHelp()) {
            return;
        }
        String cmdName = this.jc.getParsedCommand();
        if (cmdName == null) {
            this.jc.usage();
            return;
        }
        JCommander jcc = (JCommander)this.jc.getCommands().get(cmdName);
        Command cmd = (Command)jcc.getObjects().get(0);
        cmd.setOptions(this.opts);
        cmd.run();
    }

    public static void main(String[] args) {
        LogUtils.configure();
        DisUnityCli cli = new DisUnityCli();
        try {
            cli.parse(args);
            cli.run();
        }
        catch (ParameterException ex) {
            L.log(Level.WARNING, "Parameter error: {0}", ex.getMessage());
        }
        catch (Throwable t) {
            L.log(Level.SEVERE, "Fatal error", t);
        }
    }
}

