/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli;

import com.beust.jcommander.Parameter;
import info.ata4.unity.cli.classfilter.ClassFilter;
import info.ata4.unity.cli.classfilter.SimpleClassFilter;
import info.ata4.unity.cli.converters.ClassIDConverter;
import java.util.ArrayList;
import java.util.List;

public class DisUnityOptions {
    @Parameter(names={"-h", "--help"}, description="Print this help.", help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"}, description="Show more verbose log output.")
    private boolean verbose;
    @Parameter(names={"-r", "--recursive"}, description="Find all matching files recursively in all subdirectories")
    private boolean recursive;
    @Parameter(names={"-f", "--include"}, description="Only process objects that use these classes. Expects a string with class names or IDs, separated by commas.", converter=ClassIDConverter.class)
    private final List<Integer> classListInclude = new ArrayList<Integer>();
    @Parameter(names={"-x", "--exclude"}, description="Exclude objects from processing that use these classes. Expects a string with class names or IDs, separated by commas.", converter=ClassIDConverter.class)
    private final List<Integer> classListExclude = new ArrayList<Integer>();

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public ClassFilter getClassFilter() {
        return new SimpleClassFilter(this.classListInclude, this.classListExclude);
    }
}

