/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.cli.cmd.AssetCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

@Parameters(commandNames={"bundle-extract"}, commandDescription="Extracts files from asset bundles.")
public class BundleExtractCmd
extends AssetCommand {
    @Parameter(names={"--editor"}, description="Prepare extracted files for the Unity editor")
    private boolean editor;
    private static final Logger L = LogUtils.getLogger();

    public BundleExtractCmd() {
        this.setProcessAssets(false);
        this.setProcessBundledAssets(false);
    }

    @Override
    public void processAssetBundle(AssetBundle bundle) throws IOException {
        for (Map.Entry<String, ByteBuffer> entry : bundle.getEntries().entrySet()) {
            String entryName = entry.getKey();
            ByteBuffer entryBuffer = entry.getValue();
            if (this.editor && FilenameUtils.getExtension(entryName).isEmpty()) {
                entryName = entryName + ".unity";
            }
            L.log(Level.INFO, "Extracting {0}", entryName);
            Path entryFile = this.getOutputDir().resolve(entryName);
            Path entryDir = entryFile.getParent();
            if (Files.notExists(entryDir, new LinkOption[0])) {
                Files.createDirectories(entryDir, new FileAttribute[0]);
            }
            ByteBufferUtils.save((Path)entryFile, (ByteBuffer)entryBuffer);
        }
    }
}

