/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.util.PathUtils;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.cli.cmd.AssetCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Parameters(commandNames={"bundle-inject"}, commandDescription="Injects extracted files back into asset bundles.")
public class BundleInjectCmd
extends AssetCommand {
    private static final Logger L = LogUtils.getLogger();

    public BundleInjectCmd() {
        this.setProcessAssets(false);
        this.setProcessBundledAssets(false);
    }

    @Override
    public void processAssetBundle(AssetBundle bundle) throws IOException {
        Path bundleFile = bundle.getSourceFile();
        Path bundleDir = PathUtils.removeExtension((Path)bundleFile);
        if (Files.notExists(bundleDir, new LinkOption[0])) {
            L.log(Level.WARNING, "Bundle directory {0} doesn''t exist!", bundleDir);
            return;
        }
        for (Map.Entry<String, ByteBuffer> entry : bundle.getEntries().entrySet()) {
            String entryName = entry.getKey();
            Path entryFile = bundleDir.resolve(entryName);
            if (!Files.exists(entryFile, new LinkOption[0])) continue;
            L.log(Level.INFO, "Injecting {0}", entryName);
            entry.setValue(ByteBufferUtils.openReadOnly((Path)entryFile));
        }
        Path bundleFileBackup = PathUtils.append((Path)bundleFile, (String)".bak");
        Files.move(bundleFile, bundleFileBackup, StandardCopyOption.REPLACE_EXISTING);
        bundle.save(bundleFile);
    }
}

